<?php

namespace App\Http\Responses;

use Laravel\Fortify\Contracts\LoginResponse as LoginResponseContract;

class LoginResponse implements LoginResponseContract
{
    /**
     * Create an HTTP response that represents the object.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function toResponse($request)
    {
        $user = auth()->user();
        
        // Role-based redirects after login
        if ($user && ($user->hasRole('Owner') || $user->hasRole('Administrator'))) {
            return redirect('/admin/dashboard');
        } elseif ($user && $user->hasRole('LLN Specialist')) {
            return redirect('/specialist/dashboard');
        } elseif ($user && $user->hasRole('Enrolment Officer')) {
            return redirect('/officer/dashboard');
        } elseif ($user && $user->hasRole('Student')) {
            return redirect('/student/dashboard');
        }
        
        // Default fallback
        return redirect('/admin/dashboard');
    }
}