<?php

namespace App\Livewire\Admin;

use App\Models\User;
use Livewire\Component;

class Analytics extends Component
{
    public $stats = [];
    public $recentUsers = [];
    public $roleStats = [];

    public function mount()
    {
        $this->loadStats();
        $this->loadRecentUsers();
        $this->loadRoleStats();
    }

    public function loadStats()
    {
        $this->stats = [
            'total_users' => User::count(),
            'active_users' => User::where('is_active', true)->count(),
            'inactive_users' => User::where('is_active', false)->count(),
            'users_this_month' => User::whereMonth('created_at', now()->month)->count(),
        ];
    }

    public function loadRecentUsers()
    {
        $this->recentUsers = User::with('roles')
            ->orderBy('created_at', 'desc')
            ->limit(5)
            ->get();
    }

    public function loadRoleStats()
    {
        $this->roleStats = \Spatie\Permission\Models\Role::withCount('users')->get();
    }

    public function render()
    {
        return view('livewire.admin.analytics');
    }
}
