<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Learner extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'learner_id',
        'first_name',
        'last_name',
        'email',
        'custom_fields',
        'learner_form_id',
        'created_by',
        'is_active',
    ];

    protected $casts = [
        'custom_fields' => 'array',
        'is_active' => 'boolean',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'deleted_at' => 'datetime',
    ];

    /**
     * Get the learner form for this learner.
     */
    public function learnerForm(): BelongsTo
    {
        return $this->belongsTo(LearnerForm::class);
    }

    /**
     * Get the user who created this learner.
     */
    public function creator(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    /**
     * Get the full name of the learner.
     */
    public function getFullNameAttribute(): string
    {
        return $this->first_name . ' ' . $this->last_name;
    }

    /**
     * Scope to get active learners.
     */
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }
}
