<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class LearnerForm extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'name',
        'description',
        'is_active',
        'created_by',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'deleted_at' => 'datetime',
    ];

    /**
     * Get the form fields for this learner form.
     */
    public function fields(): HasMany
    {
        return $this->hasMany(LearnerFormField::class)->orderBy('sort_order');
    }

    /**
     * Get the learners for this form.
     */
    public function learners(): HasMany
    {
        return $this->hasMany(Learner::class);
    }

    /**
     * Get the user who created this form.
     */
    public function creator(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    /**
     * Scope to get active forms.
     */
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }
}
