<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;

// Fortify contracts
use Laravel\Fortify\Contracts\LoginResponse as LoginResponseContract;
use Laravel\Fortify\Contracts\RegisterResponse as RegisterResponseContract;

// Your implementations
use App\Http\Responses\LoginResponse;
use App\Http\Responses\RegisterResponse;

// (Optional) also bind view responses if you previously saw "not instantiable" errors
use Laravel\Fortify\Contracts\LoginViewResponse as LoginViewResponseContract;
use Laravel\Fortify\Http\Responses\LoginViewResponse as DefaultLoginViewResponse;
use Laravel\Fortify\Contracts\RegisterViewResponse as RegisterViewResponseContract;
use Laravel\Fortify\Http\Responses\RegisterViewResponse as DefaultRegisterViewResponse;

class AppServiceProvider extends ServiceProvider
{
    public function register(): void
    {
        // Redirect after LOGIN by role
        $this->app->singleton(LoginResponseContract::class, LoginResponse::class);

        // Redirect after REGISTER by role
        $this->app->singleton(RegisterResponseContract::class, RegisterResponse::class);

        // (Only if needed)
      //  $this->app->singleton(LoginViewResponseContract::class, DefaultLoginViewResponse::class);
//$this->app->singleton(RegisterViewResponseContract::class, DefaultRegisterViewResponse::class);
    }

    public function boot(): void {}
}
