<?php

namespace Database\Seeders;

use App\Models\EmailTemplate;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class EmailTemplateSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $templates = [
            [
                'name' => 'Learner Welcome Email',
                'slug' => 'learner-welcome-email',
                'subject' => 'Welcome to {company_name} - Your Learning Journey Begins!',
                'body' => 'Dear {learner_first_name},

{company_logo}

Welcome to {company_name}! We are excited to have you join our learning community.

Your enrollment details:
- Course: {course_name}
- Enrollment Date: {enrollment_date}
- Duration: {course_duration}

To get started, please complete your learner profile and take our initial assessment quiz. This will help us understand your current skill level and tailor the learning experience to your needs.

If you have any questions or need assistance, please don\'t hesitate to contact us at {company_email} or {company_phone}.

Best regards,
The {company_name} Team

---
{site_name}
{site_url}',
                'type' => 'learner',
                'is_active' => true,
                'description' => 'Welcome email sent to new learners upon enrollment',
                'variables' => ['company_name', 'learner_first_name', 'course_name', 'enrollment_date', 'course_duration', 'company_email', 'company_phone', 'site_name', 'site_url', 'company_logo'],
            ],
            [
                'name' => 'Quiz Completion Notification',
                'slug' => 'quiz-completion-notification',
                'subject' => 'Quiz Completed - {course_name} Assessment',
                'body' => 'Hello {learner_first_name},

Congratulations! You have successfully completed the {course_name} quiz.

Your quiz details:
- Course: {course_name}
- Completion Date: {completion_date}
- Time Taken: {quiz_duration}

Your results have been recorded and will be reviewed by our team. You will receive feedback and next steps within 2-3 business days.

Keep up the excellent work!

Best regards,
The {company_name} Team

---
{site_name}
{site_url}',
                'type' => 'learner',
                'is_active' => true,
                'description' => 'Notification sent to learners after quiz completion',
                'variables' => ['learner_first_name', 'course_name', 'completion_date', 'quiz_duration', 'company_name', 'site_name', 'site_url'],
            ],
            [
                'name' => 'Admin New Learner Alert',
                'slug' => 'admin-new-learner-alert',
                'subject' => 'New Learner Enrollment - {learner_full_name}',
                'body' => 'Hello {admin_first_name},

A new learner has enrolled in the system:

Learner Details:
- Name: {learner_full_name}
- Email: {learner_email}
- Phone: {learner_phone}
- Course: {course_name}
- Enrollment Date: {enrollment_date}

Please review their profile and ensure all necessary documentation is complete.

You can access their profile through the admin dashboard.

Best regards,
System Notification

---
{site_name}
{site_url}',
                'type' => 'admin',
                'is_active' => true,
                'description' => 'Alert sent to administrators when a new learner enrolls',
                'variables' => ['admin_first_name', 'learner_full_name', 'learner_email', 'learner_phone', 'course_name', 'enrollment_date', 'site_name', 'site_url'],
            ],
            [
                'name' => 'Course Completion Certificate',
                'slug' => 'course-completion-certificate',
                'subject' => 'Congratulations! You have completed {course_name}',
                'body' => 'Dear {learner_first_name},

Congratulations on successfully completing the {course_name} course!

Your achievement details:
- Course: {course_name}
- Completion Date: {completion_date}
- Duration: {course_duration}

Your certificate of completion is attached to this email. You can also download it anytime from your learner dashboard.

We hope you found the course valuable and wish you continued success in your learning journey.

Best regards,
The {company_name} Team

---
{site_name}
{site_url}',
                'type' => 'learner',
                'is_active' => true,
                'description' => 'Certificate email sent upon course completion',
                'variables' => ['learner_first_name', 'course_name', 'completion_date', 'course_duration', 'company_name', 'site_name', 'site_url'],
            ],
            [
                'name' => 'System Maintenance Notice',
                'slug' => 'system-maintenance-notice',
                'subject' => 'Scheduled System Maintenance - {site_name}',
                'body' => 'Hello {learner_first_name},

We would like to inform you about scheduled system maintenance:

Maintenance Details:
- Date: {maintenance_date}
- Time: {maintenance_time}
- Duration: {maintenance_duration}
- Reason: System updates and improvements

During this time, the system will be temporarily unavailable. We apologize for any inconvenience this may cause.

Please plan your learning activities accordingly and save any work in progress before the maintenance window.

If you have any urgent questions, please contact us at {company_email}.

Thank you for your understanding.

Best regards,
The {company_name} Team

---
{site_name}
{site_url}',
                'type' => 'system',
                'is_active' => true,
                'description' => 'System maintenance notification sent to all users',
                'variables' => ['learner_first_name', 'site_name', 'maintenance_date', 'maintenance_time', 'maintenance_duration', 'company_email', 'company_name', 'site_url'],
            ],
        ];

        foreach ($templates as $template) {
            EmailTemplate::create($template);
        }
    }
}
