<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\LearnerForm;
use App\Models\LearnerFormField;
use App\Models\User;

class LearnerFormSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get the first user (Owner) to create the form
        $user = User::first();
        
        if (!$user) {
            return;
        }

        // Create a default learner form
        $form = LearnerForm::create([
            'name' => 'Default Learner Registration Form',
            'description' => 'Default form for learner registration with mandatory fields',
            'is_active' => true,
            'created_by' => $user->id,
        ]);

        // Create mandatory fields
        $mandatoryFields = [
            [
                'field_name' => 'first_name',
                'field_label' => 'First Name',
                'field_type' => 'text',
                'field_options' => [],
                'is_required' => true,
                'placeholder' => 'Enter first name',
                'help_text' => '',
                'sort_order' => 1,
            ],
            [
                'field_name' => 'last_name',
                'field_label' => 'Last Name',
                'field_type' => 'text',
                'field_options' => [],
                'is_required' => true,
                'placeholder' => 'Enter last name',
                'help_text' => '',
                'sort_order' => 2,
            ],
            [
                'field_name' => 'email',
                'field_label' => 'Email',
                'field_type' => 'email',
                'field_options' => [],
                'is_required' => true,
                'placeholder' => 'Enter email address',
                'help_text' => '',
                'sort_order' => 3,
            ],
        ];

        foreach ($mandatoryFields as $fieldData) {
            $form->fields()->create($fieldData);
        }

        // Create some additional optional fields
        $optionalFields = [
            [
                'field_name' => 'phone_number',
                'field_label' => 'Phone Number',
                'field_type' => 'text',
                'field_options' => [],
                'is_required' => false,
                'placeholder' => 'Enter phone number',
                'help_text' => 'Include country code if international',
                'sort_order' => 4,
            ],
            [
                'field_name' => 'date_of_birth',
                'field_label' => 'Date of Birth',
                'field_type' => 'date',
                'field_options' => [],
                'is_required' => false,
                'placeholder' => '',
                'help_text' => '',
                'sort_order' => 5,
            ],
            [
                'field_name' => 'education_level',
                'field_label' => 'Education Level',
                'field_type' => 'select',
                'field_options' => ['High School', 'Bachelor\'s Degree', 'Master\'s Degree', 'PhD', 'Other'],
                'is_required' => false,
                'placeholder' => '',
                'help_text' => 'Select your highest education level',
                'sort_order' => 6,
            ],
        ];

        foreach ($optionalFields as $fieldData) {
            $form->fields()->create($fieldData);
        }
    }
}