<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Setting;

class SettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // General Settings
        Setting::set('site_name', 'LLN Project', 'string', 'Site name');
        Setting::set('site_email', 'admin@llnproject.com', 'string', 'Site email address');
        Setting::set('site_phone', '', 'string', 'Site phone number');
        Setting::set('site_address', '', 'string', 'Site address');
        Setting::set('copyright_text', '© 2024 LLN Project. All rights reserved.', 'string', 'Copyright text');
        Setting::set('site_logo', '', 'string', 'Site logo');
        
        // Organisation Information
        Setting::set('company_name', 'Skills Australia Institute', 'string', 'Company name');
        Setting::set('learner_correspondence_name', 'Skills Australia Institute', 'string', 'Learner correspondence name');
        Setting::set('learner_correspondence_phone', '+61 410001429', 'string', 'Learner correspondence phone');
        Setting::set('learner_correspondence_email', 'admissions@skillsaustralia.edu.au', 'string', 'Learner correspondence email');
        Setting::set('learner_redirection_url', 'http://www.skillsaustralia.edu.au', 'string', 'Learner redirection URL');
        Setting::set('admin_correspondence_name', 'Skills Australia Institute', 'string', 'Admin correspondence name');
        Setting::set('admin_correspondence_email', 'admissions@skillsaustralia.edu.au', 'string', 'Admin correspondence email');
        
        // Quiz Settings
        Setting::set('daily_summary_quiz_completion_email', true, 'boolean', 'Daily summary quiz completion email');
        Setting::set('daily_summary_email_contact', 'default admin correspondence', 'string', 'Daily summary email contact');
        Setting::set('immediate_quiz_completion_emails', true, 'boolean', 'Immediate quiz completion emails');
        Setting::set('immediate_completion_email_contact', 'default admin correspondence', 'string', 'Immediate completion email contact');
        Setting::set('deleted_learner_notifications', false, 'boolean', 'Deleted learner notifications');
        Setting::set('incomplete_reminders_to_learners', false, 'boolean', 'Incomplete reminders to learners');
        Setting::set('learner_pre_enrolment_report', false, 'boolean', 'Learner pre-enrolment report');
        Setting::set('quiz_reminder_days', 7, 'integer', 'Days to send quiz reminders');
        Setting::set('quiz_reminder_gap_days', 3, 'integer', 'Gap between quiz reminders in days');
        
        // System Settings
        Setting::set('maintenance_mode', false, 'boolean', 'Maintenance mode');
        Setting::set('user_registration', true, 'boolean', 'Allow user registration');
        Setting::set('email_notifications', true, 'boolean', 'Email notifications');
        Setting::set('session_timeout', 120, 'integer', 'Session timeout in minutes');
        Setting::set('max_login_attempts', 5, 'integer', 'Maximum login attempts');
        Setting::set('password_min_length', 8, 'integer', 'Minimum password length');
        Setting::set('require_password_confirmation', true, 'boolean', 'Require password confirmation');
    }
}