<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    
    <title>Reset Password - {{ \App\Models\Setting::get('site_name', config('app.name', 'LLN Quiz Portal')) }}</title>

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="shortcut icon" href="{{ asset('favicon.ico') }}" />
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <!-- Custom CSS -->
    <link href="{{ asset('css/auth.css') }}" rel="stylesheet">

    @livewireStyles
</head>

<body>
    <div class="auth-container">
        <!-- Background Elements -->
        <div class="auth-background">
            <div class="floating-shape shape-1"></div>
            <div class="floating-shape shape-2"></div>
            <div class="floating-shape shape-3"></div>
        </div>

        <div class="auth-card">
            <!-- Auth Header -->
            <div class="auth-header">
                <div class="auth-logo">
                    @php
                        $logoPath = \App\Models\Setting::get('site_logo');
                        $logoUrl = $logoPath ? \Storage::url($logoPath) : null;
                    @endphp
                    @if($logoUrl && \Storage::disk('public')->exists($logoPath))
                        <img src="{{ $logoUrl }}" alt="{{ \App\Models\Setting::get('site_name', config('app.name')) }} Logo" class="img-fluid">
                    @else
                        <div class="default-logo">
                            <i class="fas fa-lock"></i>
                        </div>
                    @endif
                </div>
                <h1 class="auth-title">Reset Password</h1>
                <p class="auth-subtitle">Enter your new password below</p>
            </div>

            <!-- Auth Body -->
            <div class="auth-body">
                @if (session('status'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="fas fa-check-circle me-2"></i>
                        {{ session('status') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                @if ($errors->any())
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        @foreach ($errors->all() as $error)
                            {{ $error }}<br>
                        @endforeach
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                <!-- Reset Password Form -->
                <form method="POST" action="{{ route('password.update') }}" id="resetPasswordForm">
                    @csrf
                    <input type="hidden" name="token" value="{{ $token }}">

                    <div class="row mb-3 align-items-center">
                        <div class="col-md-4 col-12">
                            <label class="form-label d-flex align-items-center mb-2 mb-md-0" for="email">
                                <i class="fas fa-envelope me-1"></i>
                                Email Address
                            </label>
                        </div>
                        <div class="col-md-8 col-12">
                            <input
                                id="email"
                                class="form-control @error('email') is-invalid @enderror"
                                type="email"
                                name="email"
                                placeholder="Enter your email address"
                                value="{{ old('email') }}"
                                required
                                autofocus
                            />
                            @error('email')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="row mb-3 align-items-center">
                        <div class="col-md-4 col-12">
                            <label class="form-label d-flex align-items-center mb-2 mb-md-0" for="password">
                                <i class="fas fa-lock me-1"></i>
                                New Password
                            </label>
                        </div>
                        <div class="col-md-8 col-12">
                            <div class="input-group">
                                <input
                                    id="password"
                                    class="form-control @error('password') is-invalid @enderror"
                                    type="password"
                                    name="password"
                                    placeholder="Enter your new password"
                                    required
                                />
                                <button class="btn btn-outline-secondary" type="button" id="togglePassword">
                                    <i class="fas fa-eye"></i>
                                </button>
                            </div>
                            @error('password')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="row mb-3 align-items-center">
                        <div class="col-md-4 col-12">
                            <label class="form-label d-flex align-items-center mb-2 mb-md-0" for="password_confirmation">
                                <i class="fas fa-lock me-1"></i>
                                Confirm Password
                            </label>
                        </div>
                        <div class="col-md-8 col-12">
                            <div class="input-group">
                                <input
                                    id="password_confirmation"
                                    class="form-control"
                                    type="password"
                                    name="password_confirmation"
                                    placeholder="Confirm your new password"
                                    required
                                />
                                <button class="btn btn-outline-secondary" type="button" id="togglePasswordConfirmation">
                                    <i class="fas fa-eye"></i>
                                </button>
                            </div>
                        </div>
                    </div>

                    <div class="d-grid gap-2">
                        <button type="submit" class="btn-auth btn-primary-auth" id="resetPasswordBtn">
                            <i class="fas fa-save me-2"></i>
                            Reset Password
                        </button>
                    </div>
                </form>
            </div>

            <!-- Auth Footer -->
            <div class="auth-footer">
                <div class="auth-footer-text">
                    Remember your password?
                    <a href="{{ route('login') }}" class="auth-link">Sign in here</a>
                </div>
                <p class="auth-copyright">
                    {{ \App\Models\Setting::get('copyright_text', '© ' . date('Y') . ' LLN Quiz Portal. All rights reserved.') }}
                </p>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- JavaScript -->
    <script>
        // Form submission with loading state
        document.getElementById('resetPasswordForm').addEventListener('submit', function() {
            const btn = document.getElementById('resetPasswordBtn');
            btn.classList.add('loading');
            btn.disabled = true;
        });

        // Auto-hide alerts after 5 seconds
        setTimeout(function() {
            const alerts = document.querySelectorAll('.alert');
            alerts.forEach(function(alert) {
                alert.style.transition = 'opacity 0.5s ease';
                alert.style.opacity = '0';
                setTimeout(function() {
                    alert.remove();
                }, 500);
            });
        }, 5000);

        // Password toggle functionality
        function setupPasswordToggle(toggleId, inputId) {
            const toggleBtn = document.getElementById(toggleId);
            const passwordInput = document.getElementById(inputId);
            
            if (toggleBtn && passwordInput) {
                toggleBtn.addEventListener('click', function() {
                    const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
                    passwordInput.setAttribute('type', type);
                    
                    const icon = toggleBtn.querySelector('i');
                    icon.classList.toggle('fa-eye');
                    icon.classList.toggle('fa-eye-slash');
                });
            }
        }

        // Setup password toggles
        setupPasswordToggle('togglePassword', 'password');
        setupPasswordToggle('togglePasswordConfirmation', 'password_confirmation');

        // Password confirmation validation
        const password = document.getElementById('password');
        const passwordConfirmation = document.getElementById('password_confirmation');

        function validatePasswordMatch() {
            if (password.value !== passwordConfirmation.value) {
                passwordConfirmation.setCustomValidity('Passwords do not match');
            } else {
                passwordConfirmation.setCustomValidity('');
            }
        }

        password.addEventListener('change', validatePasswordMatch);
        passwordConfirmation.addEventListener('keyup', validatePasswordMatch);

        // Add focus effects to form controls
        const formControls = document.querySelectorAll('.form-control');
        formControls.forEach(function(control) {
            control.addEventListener('focus', function() {
                this.parentElement.classList.add('focused');
            });
            
            control.addEventListener('blur', function() {
                if (!this.value) {
                    this.parentElement.classList.remove('focused');
                }
            });
        });
    </script>

    @livewireScripts
</body>
</html>


