@extends('Admin.layouts.layout')

@section('content')
    <div class="container-fluid px-4 py-3">
        <!-- Page Header -->
        <div class="page-header-two-row">
            <div class="page-title-row">
                <h1 class="page-title-two-row">
                    <i class="fas fa-question-circle"></i>
                    {{ $quiz->title }}
                </h1>
            </div>
            <div class="page-actions-row">
                <div class="breadcrumb-section">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{ route('admin.dashboard') }}">
                                    <i class="fas fa-home me-1"></i>Dashboard
                                </a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="{{ route('admin.quizzes') }}">
                                    <i class="fas fa-question-circle me-1"></i>Quizzes
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">
                                {{ $quiz->title }}
                            </li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>

        <!-- Quiz Details -->
        <div class="row">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-info-circle me-2"></i>Quiz Details
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <h6>Description</h6>
                                <p>{{ $quiz->description ?: 'No description provided' }}</p>
                                
                                <h6>Status</h6>
                                @switch($quiz->status)
                                    @case('draft')
                                        <span class="badge bg-secondary">Draft</span>
                                        @break
                                    @case('published')
                                        <span class="badge bg-success">Published</span>
                                        @break
                                    @case('archived')
                                        <span class="badge bg-warning">Archived</span>
                                        @break
                                @endswitch
                                
                                <h6>Visibility</h6>
                                @switch($quiz->visibility)
                                    @case('private')
                                        <span class="badge bg-danger">Private</span>
                                        @break
                                    @case('public')
                                        <span class="badge bg-success">Public</span>
                                        @break
                                    @case('unlisted')
                                        <span class="badge bg-warning">Unlisted</span>
                                        @break
                                @endswitch
                            </div>
                            <div class="col-md-6">
                                <h6>Statistics</h6>
                                <ul class="list-unstyled">
                                    <li><strong>Questions:</strong> {{ $quiz->total_questions }}</li>
                                    <li><strong>Total Points:</strong> {{ $quiz->total_points }}</li>
                                    <li><strong>Duration:</strong> {{ $quiz->duration_minutes ? $quiz->duration_minutes . ' minutes' : 'No time limit' }}</li>
                                    <li><strong>Version:</strong> {{ $quiz->version }}</li>
                                </ul>
                                
                                <h6>Timeline</h6>
                                <ul class="list-unstyled">
                                    <li><strong>Created:</strong> {{ $quiz->created_at->format('M d, Y H:i') }}</li>
                                    @if($quiz->published_at)
                                        <li><strong>Published:</strong> {{ $quiz->published_at->format('M d, Y H:i') }}</li>
                                    @endif
                                    @if($quiz->expires_at)
                                        <li><strong>Expires:</strong> {{ $quiz->expires_at->format('M d, Y H:i') }}</li>
                                    @endif
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Questions -->
                <div class="card mt-4">
                    <div class="card-header">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-list me-2"></i>Questions ({{ $quiz->questions->count() }})
                        </h5>
                    </div>
                    <div class="card-body">
                        @forelse($quiz->questions as $index => $question)
                        <div class="question-item border rounded p-3 mb-3">
                            <div class="d-flex justify-content-between align-items-start">
                                <div class="flex-grow-1">
                                    <h6 class="mb-2">
                                        <span class="badge bg-primary me-2">{{ $index + 1 }}</span>
                                        {{ $question->question_text }}
                                    </h6>
                                    <div class="d-flex gap-3">
                                        <small class="text-muted">
                                            <i class="fas fa-tag me-1"></i>{{ $question->type_label }}
                                        </small>
                                        <small class="text-muted">
                                            <i class="fas fa-star me-1"></i>{{ $question->score_points }} points
                                        </small>
                                        @if($question->is_required)
                                            <small class="text-danger">
                                                <i class="fas fa-asterisk me-1"></i>Required
                                            </small>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                        @empty
                        <div class="text-center py-4">
                            <i class="fas fa-question-circle fa-3x text-muted mb-3"></i>
                            <p class="text-muted">No questions added yet</p>
                        </div>
                        @endforelse
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <!-- Actions -->
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-cogs me-2"></i>Actions
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <a href="{{ route('admin.quizzes.edit', $quiz) }}" class="btn btn-primary">
                                <i class="fas fa-edit me-1"></i>Edit Quiz
                            </a>
                            <a href="{{ route('admin.quizzes.questions', $quiz) }}" class="btn btn-info">
                                <i class="fas fa-question-circle me-1"></i>Manage Questions
                            </a>
                            <a href="{{ route('admin.quizzes.invitations', $quiz) }}" class="btn btn-warning">
                                <i class="fas fa-envelope me-1"></i>Send Invitations
                            </a>
                            @if($quiz->status === 'draft')
                                <button type="button" class="btn btn-success">
                                    <i class="fas fa-publish me-1"></i>Publish Quiz
                                </button>
                            @elseif($quiz->status === 'published')
                                <button type="button" class="btn btn-warning">
                                    <i class="fas fa-unpublish me-1"></i>Unpublish Quiz
                                </button>
                            @endif
                            <a href="{{ route('admin.quizzes.analytics', $quiz) }}" class="btn btn-info">
                                <i class="fas fa-chart-bar me-1"></i>View Analytics
                            </a>
                            <button type="button" class="btn btn-outline-secondary">
                                <i class="fas fa-copy me-1"></i>Duplicate Quiz
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Quick Stats -->
                <div class="card mt-4">
                    <div class="card-header">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-chart-pie me-2"></i>Quick Stats
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row text-center">
                            <div class="col-6">
                                <h4 class="text-primary">{{ $quiz->attempts->count() }}</h4>
                                <small class="text-muted">Total Attempts</small>
                            </div>
                            <div class="col-6">
                                <h4 class="text-success">{{ $quiz->attempts->where('status', 'completed')->count() }}</h4>
                                <small class="text-muted">Completed</small>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Creator Info -->
                <div class="card mt-4">
                    <div class="card-header">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-user me-2"></i>Creator
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="avatar-circle bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 40px; height: 40px;">
                                {{ substr($quiz->creator->name ?? 'U', 0, 1) }}
                            </div>
                            <div>
                                <h6 class="mb-0">{{ $quiz->creator->name ?? 'Unknown' }}</h6>
                                <small class="text-muted">{{ $quiz->creator->email ?? '' }}</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
