<div>
<div class="container-fluid px-4 py-3">
    <!-- Page Header -->
    <div class="page-header-two-row">
        <div class="page-title-row">
            <h1 class="page-title-two-row">
                <i class="fas fa-{{ $editMode ? 'edit' : 'plus' }}"></i>
                {{ $editMode ? 'Edit Email Template' : 'Create New Email Template' }}
            </h1>
        </div>
        <div class="page-actions-row">
            <div class="breadcrumb-section">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.dashboard') }}">
                                <i class="fas fa-home me-1"></i>Dashboard
                            </a>
                        </li>
                        <li class="breadcrumb-item">
                            <a href="#" onclick="toggleEmailMenu(event)">
                                <i class="fas fa-envelope me-1"></i>Email Templates
                            </a>
                        </li>
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.email-templates') }}">
                                <i class="fas fa-file-text me-1"></i>Templates
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            <i class="fas fa-{{ $editMode ? 'edit' : 'plus' }} me-1"></i>
                            {{ $editMode ? 'Edit Template' : 'Create Template' }}
                        </li>
                    </nav>
                </ol>
            </div>
            <div class="action-section">
                <a href="{{ route('admin.email-templates') }}" class="btn btn-outline-secondary">
                    <i class="fas fa-arrow-left me-2"></i>Back to Templates
                </a>
            </div>
        </div>
    </div>

    <!-- Form Content -->
    <div class="row justify-content-center">
        <div class="col-12 col-xl-10 col-lg-11">
            <form wire:submit.prevent="save" id="emailTemplateForm">
                <!-- Basic Information -->
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-light">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-info-circle me-2 text-primary"></i>
                            Template Information
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-12 col-md-6">
                                <label for="name" class="form-label fw-semibold">
                                    <i class="fas fa-tag me-1 text-muted"></i>Template Name *
                                </label>
                                <input type="text"
                                       class="form-control @error('name') is-invalid @enderror"
                                       id="name"
                                       wire:model="name"
                                       placeholder="Enter template name"
                                       required>
                                @error('name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-12 col-md-6">
                                <label for="type" class="form-label fw-semibold">
                                    <i class="fas fa-filter me-1 text-muted"></i>Template Type *
                                </label>
                                <select class="form-select @error('type') is-invalid @enderror"
                                        id="type"
                                        wire:model="type"
                                        required>
                                    <option value="">Select template type</option>
                                    @foreach($typeOptions as $key => $label)
                                        <option value="{{ $key }}">{{ $label }}</option>
                                    @endforeach
                                </select>
                                @error('type')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-12">
                                <label for="description" class="form-label fw-semibold">
                                    <i class="fas fa-align-left me-1 text-muted"></i>Description
                                </label>
                                <textarea class="form-control @error('description') is-invalid @enderror resize-vertical"
                                          id="description"
                                          wire:model="description"
                                          rows="3"
                                          placeholder="Enter template description"></textarea>
                                @error('description')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-12 col-md-6">
                                <div class="form-check form-switch d-flex align-items-center">
                                    <input class="form-check-input me-3"
                                           type="checkbox"
                                           id="is_active"
                                           wire:model="is_active">
                                    <label class="form-check-label fw-semibold" for="is_active">
                                        Active Template
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Email Content -->
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-light">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-envelope me-2 text-primary"></i>
                            Email Content
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-12">
                                <label for="subject" class="form-label fw-semibold">
                                    <i class="fas fa-heading me-1 text-muted"></i>Email Subject *
                                </label>
                                <input type="text"
                                       class="form-control @error('subject') is-invalid @enderror"
                                       id="subject"
                                       wire:model="subject"
                                       placeholder="Enter email subject"
                                       required>
                                @error('subject')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-12">
                                <label for="body" class="form-label fw-semibold">
                                    <i class="fas fa-align-left me-1 text-muted"></i>Email Body *
                                </label>
                                <textarea class="form-control @error('body') is-invalid @enderror resize-vertical"
                                          id="body"
                                          wire:model="body"
                                          rows="10"
                                          placeholder="Enter email body content"
                                          required></textarea>
                                @error('body')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Available Variables -->
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-gradient-light">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-code me-2 text-dark"></i>
                            Available Variables
                        </h5>
                        <small class="text-muted">Click on variables to insert them into your template</small>
                    </div>
                    <div class="card-body">
                        @foreach($availableVariables as $category => $variables)
                            <div class="mb-4">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="variable-category-header">
                                        <i class="fas fa-folder me-2 text-white"></i>{{ ucfirst($category) }} Variables
                                    </div>
                                </div>
                                <div class="row g-2">
                                    @foreach($variables as $key => $label)
                                        <div class="col-md-6 col-lg-4">
                                            <button type="button" 
                                                    class="btn variable-button w-100 text-start"
                                                    onclick="insertVariableAtCursor('{{ $key }}')"
                                                    title="Insert {{ $label }}"
                                                    data-variable="{{ $key }}">
                                                <div class="variable-content">
                                                    <code class="variable-code">{{ $key }}</code>
                                                    <small class="variable-label">{{ $label }}</small>
                                                </div>
                                            </button>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>

                <!-- Selected Variables -->
                @if(count($selectedVariables) > 0)
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-gradient-light">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-list me-2 text-dark"></i>
                            Selected Variables
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-2">
                            @foreach($selectedVariables as $index => $variable)
                                <div class="col-md-6 col-lg-4">
                                    <div class="selected-variable-item">
                                        <div class="selected-variable-content">
                                            <code class="selected-variable-code">{{ $variable }}</code>
                                        </div>
                                        <button type="button" 
                                                class="btn btn-sm selected-variable-remove"
                                                wire:click="removeVariable({{ $index }})"
                                                title="Remove variable">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
                @endif

                <!-- Form Actions -->
                <div class="card shadow-sm">
                    <div class="card-footer bg-light text-end">
                        <div class="d-flex flex-column flex-md-row justify-content-between gap-2">
                            <button type="button" class="btn btn-secondary" wire:click="cancel">
                                <i class="fas fa-times me-2"></i>Cancel
                            </button>
                            <button type="submit" class="btn btn-primary" wire:loading.attr="disabled">
                                <span wire:loading.remove wire:target="save">
                                    <i class="fas fa-{{ $editMode ? 'save' : 'plus' }} me-2"></i>
                                    {{ $editMode ? 'Update Template' : 'Create Template' }}
                                </span>
                                <span wire:loading wire:target="save">
                                    <i class="fas fa-spinner fa-spin me-2"></i>Processing...
                                </span>
                            </button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
let currentField = null;

// Track which field is currently focused
document.addEventListener('DOMContentLoaded', function() {
    const subjectField = document.getElementById('subject');
    const bodyField = document.getElementById('body');
    
    if (subjectField) {
        subjectField.addEventListener('focus', function() {
            currentField = 'subject';
        });
    }
    
    if (bodyField) {
        bodyField.addEventListener('focus', function() {
            currentField = 'body';
        });
    }
});

function insertVariableAtCursor(variable) {
    const variableText = '{' + variable + '}';
    
    if (currentField === 'subject') {
        insertAtCursor('subject', variableText);
    } else if (currentField === 'body') {
        insertAtCursor('body', variableText);
    } else {
        // If no field is focused, default to body field
        insertAtCursor('body', variableText);
        // Focus the body field
        const bodyField = document.getElementById('body');
        if (bodyField) {
            bodyField.focus();
        }
    }
}

function insertAtCursor(fieldId, text) {
    const field = document.getElementById(fieldId);
    if (!field) return;
    
    // Get cursor position
    const start = field.selectionStart;
    const end = field.selectionEnd;
    
    // Get current value
    const value = field.value;
    
    // Insert the variable at cursor position
    const newValue = value.substring(0, start) + text + value.substring(end);
    
    // Update the field value
    field.value = newValue;
    
    // Update Livewire component
    if (fieldId === 'subject') {
        @this.set('subject', field.value);
    } else if (fieldId === 'body') {
        @this.set('body', field.value);
    }
    
    // Set cursor position after the inserted text
    const newCursorPos = start + text.length;
    field.setSelectionRange(newCursorPos, newCursorPos);
    
    // Focus the field
    field.focus();
}
</script>

<!-- Quill.js Rich Text Editor -->
<link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">
<script src="https://cdn.quilljs.com/1.3.6/quill.min.js"></script>
<style>
/* Quill.js Container Styling - Force containment within card body */
.ql-editor {
    max-width: 100% !important;
    width: 100% !important;
    overflow-wrap: break-word !important;
    word-wrap: break-word !important;
    word-break: break-word !important;
    box-sizing: border-box !important;
    padding: 8px 12px !important;
    min-height: 80px !important;
}

.ql-toolbar {
    max-width: 100% !important;
    width: 100% !important;
    overflow-x: auto !important;
    box-sizing: border-box !important;
    padding: 8px !important;
}

.ql-container {
    max-width: 100% !important;
    width: 100% !important;
    box-sizing: border-box !important;
    margin: 0 !important;
    padding: 0 !important;
}

#description {
    max-width: 100% !important;
    width: 100% !important;
    overflow: hidden !important;
    margin: 0 !important;
    padding: 0 !important;
}

/* Force Quill to stay within card body */
.card-body #description {
    width: 100% !important;
    max-width: 100% !important;
    overflow: hidden !important;
}

.card-body .ql-toolbar {
    width: 100% !important;
    max-width: 100% !important;
    overflow-x: auto !important;
}

.card-body .ql-container {
    width: 100% !important;
    max-width: 100% !important;
    overflow: hidden !important;
}

.card-body .ql-editor {
    width: 100% !important;
    max-width: 100% !important;
    overflow-wrap: break-word !important;
}

/* Ensure the editor stays within bounds */
.ql-snow .ql-toolbar {
    border-left: 1px solid #ccc !important;
    border-right: 1px solid #ccc !important;
    border-top: 1px solid #ccc !important;
    border-bottom: none !important;
}

.ql-snow .ql-container {
    border-left: 1px solid #ccc !important;
    border-right: 1px solid #ccc !important;
    border-bottom: 1px solid #ccc !important;
    border-top: none !important;
}

/* Additional containment rules */
.ql-snow {
    max-width: 100% !important;
    width: 100% !important;
}

/* Prevent any overflow */
.card-body {
    overflow: hidden !important;
}

/* Ensure form control doesn't exceed container */
.form-control {
    max-width: 100% !important;
}
</style>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Initialize Quill.js for description field
    const quill = new Quill('#description', {
        theme: 'snow',
        modules: {
            toolbar: [
                [{ 'header': [1, 2, 3, false] }],
                ['bold', 'italic', 'underline'],
                [{ 'list': 'ordered'}, { 'list': 'bullet' }],
                [{ 'align': [] }],
                ['link'],
                ['clean']
            ]
        },
        placeholder: 'Enter template description...',
        bounds: '#description'
    });

    // Update Livewire component when content changes
    quill.on('text-change', function() {
        @this.set('description', quill.root.innerHTML);
    });
    
    // Set initial content if editing
    if (@this.description) {
        quill.root.innerHTML = @this.description;
    }
    
    // Update Quill content when Livewire updates
    document.addEventListener('livewire:update', function() {
        if (@this.description && quill.root.innerHTML !== @this.description) {
            quill.root.innerHTML = @this.description || '';
        }
    });
});
</script>
</div>