<div class="container-fluid px-4 py-3">
    <!-- Page Header -->
    <div class="page-header-two-row">
        <div class="page-title-row">
            <h1 class="page-title-two-row">
                <i class="fas fa-tag"></i>
                Email Template Types
            </h1>
        </div>
        <div class="page-actions-row">
            <div class="breadcrumb-section">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.dashboard') }}">
                                <i class="fas fa-home me-1"></i>Dashboard
                            </a>
                        </li>
                        <li class="breadcrumb-item">
                            <a href="#" onclick="toggleEmailMenu(event)">
                                <i class="fas fa-envelope me-1"></i>Email Templates
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            <i class="fas fa-tag me-1"></i>Template Types
                        </li>
                    </ol>
                </nav>
            </div>
            <div class="action-section">
                @can('email-template-types.create')
                <a href="{{ route('admin.email-template-types.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus me-2"></i>Add New Type
                </a>
                @endcan
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="card shadow-sm mb-4">
        <div class="card-body">
            <div class="row g-3">
                <div class="col-md-4">
                    <div class="input-group">
                        <span class="input-group-text"><i class="fas fa-search"></i></span>
                        <input type="text" 
                               class="form-control" 
                               placeholder="Search types..." 
                               wire:model.live.debounce.300ms="search">
                    </div>
                </div>
                <div class="col-md-3">
                    <select class="form-select" wire:model.live="statusFilter">
                        <option value="">All Status</option>
                        <option value="1">Active</option>
                        <option value="0">Inactive</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <button type="button" class="btn btn-outline-secondary w-100" wire:click="clearFilters">
                        <i class="fas fa-times me-2"></i>Clear
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Types Table -->
    <div class="card shadow-sm">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead class="table-light">
                        <tr>
                            <th class="border-0">
                                <button type="button" class="btn btn-link p-0 text-decoration-none fw-bold" wire:click="sortBy('name')">
                                    Name
                                    @if($sortField === 'name')
                                        <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }} ms-1"></i>
                                    @endif
                                </button>
                            </th>
                            <th class="border-0">Description</th>
                            <th class="border-0">Color</th>
                            <th class="border-0">Icon</th>
                            <th class="border-0">
                                <button type="button" class="btn btn-link p-0 text-decoration-none fw-bold" wire:click="sortBy('sort_order')">
                                    Order
                                    @if($sortField === 'sort_order')
                                        <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }} ms-1"></i>
                                    @endif
                                </button>
                            </th>
                            <th class="border-0">Templates</th>
                            <th class="border-0">
                                <button type="button" class="btn btn-link p-0 text-decoration-none fw-bold" wire:click="sortBy('is_active')">
                                    Status
                                    @if($sortField === 'is_active')
                                        <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }} ms-1"></i>
                                    @endif
                                </button>
                            </th>
                            <th class="border-0">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($types as $type)
                        <tr>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="type-color-indicator me-3" style="background-color: {{ $type->color }};"></div>
                                    <div>
                                        <div class="fw-semibold">{{ $type->name }}</div>
                                        <small class="text-muted">{{ $type->slug }}</small>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <span class="text-muted">{{ Str::limit($type->description, 50) ?: 'No description' }}</span>
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="color-preview me-2" style="background-color: {{ $type->color }};"></div>
                                    <code class="text-muted">{{ $type->color }}</code>
                                </div>
                            </td>
                            <td>
                                <i class="{{ $type->icon }} text-muted"></i>
                            </td>
                            <td>
                                <span class="badge bg-secondary">{{ $type->sort_order }}</span>
                            </td>
                            <td>
                                <span class="badge bg-info">{{ $type->templates_count }}</span>
                            </td>
                            <td>
                                @if($type->is_active)
                                    <span class="badge bg-success">Active</span>
                                @else
                                    <span class="badge bg-secondary">Inactive</span>
                                @endif
                            </td>
                            <td>
                                <div class="btn-group btn-group-sm">
                                    @can('email-template-types.edit')
                                    <a href="{{ route('admin.email-template-types.edit', $type->id) }}" 
                                       class="btn btn-outline-primary" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    @endcan
                                    
                                    @can('email-template-types.edit')
                                    <button type="button" 
                                            class="btn btn-outline-{{ $type->is_active ? 'warning' : 'success' }}"
                                            wire:click="toggleStatus({{ $type->id }})" 
                                            title="{{ $type->is_active ? 'Deactivate' : 'Activate' }}">
                                        <i class="fas fa-{{ $type->is_active ? 'pause' : 'play' }}"></i>
                                    </button>
                                    @endcan
                                    
                                    @can('email-template-types.delete')
                                    <button type="button" 
                                            class="btn btn-outline-danger"
                                            wire:click="deleteType({{ $type->id }})" 
                                            title="Delete"
                                            onclick="return confirm('Are you sure you want to delete this template type?')">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                    @endcan
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="8" class="text-center py-4">
                                <div class="text-muted">
                                    <i class="fas fa-inbox fa-3x mb-3"></i>
                                    <p class="mb-0">No email template types found.</p>
                                    @if($search || $statusFilter)
                                        <p class="small">Try adjusting your search criteria.</p>
                                    @endif
                                </div>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        
        @if($types->hasPages())
        <div class="card-footer">
            <div class="d-flex justify-content-between align-items-center">
                <div class="text-muted">
                    Showing {{ $types->firstItem() }} to {{ $types->lastItem() }} of {{ $types->total() }} results
                </div>
                <div>
                    {{ $types->links() }}
                </div>
            </div>
        </div>
        @endif
    </div>

    <!-- Mobile Card View -->
    <div class="d-md-none">
        @foreach($types as $type)
        <div class="card shadow-sm mb-3">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start mb-3">
                    <div class="d-flex align-items-center">
                        <div class="type-color-indicator me-3" style="background-color: {{ $type->color }};"></div>
                        <div>
                            <h6 class="mb-0 fw-semibold">{{ $type->name }}</h6>
                            <small class="text-muted">{{ $type->slug }}</small>
                        </div>
                    </div>
                    <div class="dropdown">
                        <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                            <i class="fas fa-ellipsis-v"></i>
                        </button>
                        <ul class="dropdown-menu">
                            @can('email-template-types.edit')
                            <li><a class="dropdown-item" href="{{ route('admin.email-template-types.edit', $type->id) }}">
                                <i class="fas fa-edit me-2"></i>Edit
                            </a></li>
                            @endcan
                            
                            @can('email-template-types.edit')
                            <li><a class="dropdown-item" href="#" wire:click="toggleStatus({{ $type->id }})">
                                <i class="fas fa-{{ $type->is_active ? 'pause' : 'play' }} me-2"></i>
                                {{ $type->is_active ? 'Deactivate' : 'Activate' }}
                            </a></li>
                            @endcan
                            
                            @can('email-template-types.delete')
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item text-danger" href="#" wire:click="deleteType({{ $type->id }})" onclick="return confirm('Are you sure?')">
                                <i class="fas fa-trash me-2"></i>Delete
                            </a></li>
                            @endcan
                        </ul>
                    </div>
                </div>
                
                <div class="row g-2 mb-3">
                    <div class="col-6">
                        <small class="text-muted d-block">Description</small>
                        <span class="small">{{ Str::limit($type->description, 30) ?: 'No description' }}</span>
                    </div>
                    <div class="col-6">
                        <small class="text-muted d-block">Templates</small>
                        <span class="badge bg-info">{{ $type->templates_count }}</span>
                    </div>
                </div>
                
                <div class="row g-2">
                    <div class="col-4">
                        <small class="text-muted d-block">Color</small>
                        <div class="d-flex align-items-center">
                            <div class="color-preview me-1" style="background-color: {{ $type->color }};"></div>
                            <code class="small">{{ $type->color }}</code>
                        </div>
                    </div>
                    <div class="col-4">
                        <small class="text-muted d-block">Icon</small>
                        <i class="{{ $type->icon }}"></i>
                    </div>
                    <div class="col-4">
                        <small class="text-muted d-block">Status</small>
                        @if($type->is_active)
                            <span class="badge bg-success">Active</span>
                        @else
                            <span class="badge bg-secondary">Inactive</span>
                        @endif
                    </div>
                </div>
            </div>
        </div>
        @endforeach
    </div>
</div>