<div class="container-fluid px-4 py-3">
    <!-- Page Header -->
    <div class="page-header-two-row">
        <div class="page-title-row">
            <h1 class="page-title-two-row">
                <i class="fas fa-{{ $editMode ? 'edit' : 'plus' }}"></i>
                {{ $editMode ? 'Edit Learner Form' : 'Create New Learner Form' }}
            </h1>
        </div>
        <div class="page-actions-row">
            <div class="breadcrumb-section">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.dashboard') }}">
                                <i class="fas fa-home me-1"></i>Dashboard
                            </a>
                        </li>
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.learner-forms') }}">
                                <i class="fas fa-users me-1"></i>Learner Forms
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            <i class="fas fa-{{ $editMode ? 'edit' : 'plus' }} me-1"></i>
                            {{ $editMode ? 'Edit Form' : 'Create Form' }}
                        </li>
                    </ol>
                </nav>
            </div>
            <div class="action-section">
                <a href="{{ route('admin.learner-forms') }}" class="btn btn-outline-secondary">
                    <i class="fas fa-arrow-left me-2"></i>Back to Forms
                </a>
            </div>
        </div>
    </div>

    <!-- Form Content -->
    <div class="row justify-content-center">
        <div class="col-12 col-xl-10 col-lg-11">
            <!-- Form Card -->
            <div class="card shadow-lg border-0">
                <div class="card-header bg-gradient-primary text-white">
                    <div class="row align-items-center">
                        <div class="col">
                            <h5 class="card-title mb-0 text-white">
                                <i class="fas fa-{{ $editMode ? 'edit' : 'plus' }} me-2"></i>
                                {{ $editMode ? 'Edit Form Information' : 'Create New Learner Form' }}
                            </h5>
                            <p class="text-white-50 mb-0 mt-1">
                                {{ $editMode ? 'Update form details and fields' : 'Configure your learner form with custom fields' }}
                            </p>
                        </div>
                    </div>
                </div>
                <div class="card-body p-4">
                    <form wire:submit.prevent="save" id="learnerForm">
                        <!-- Basic Information -->
                        <div class="form-section mb-5">
                            <div class="section-header mb-4">
                                <h6 class="section-title">
                                    <i class="fas fa-info-circle me-2"></i>Basic Information
                                </h6>
                                <div class="section-line"></div>
                            </div>
                            <div class="row g-4">
                                <div class="col-12">
                                    <label for="formName" class="form-label fw-semibold">
                                        <i class="fas fa-heading me-1 text-primary"></i>Form Name *
                                    </label>
                                    <input type="text" 
                                           class="form-control form-control-lg @error('formName') is-invalid @enderror" 
                                           id="formName" 
                                           wire:model="formName" 
                                           placeholder="Enter form name"
                                           required>
                                    @error('formName') 
                                        <div class="invalid-feedback">{{ $message }}</div> 
                                    @enderror
                                </div>
                                
                                <div class="col-12">
                                    <label for="formDescription" class="form-label fw-semibold">
                                        <i class="fas fa-align-left me-1 text-primary"></i>Description
                                    </label>
                                    <textarea class="form-control @error('formDescription') is-invalid @enderror resize-vertical" 
                                              id="formDescription" 
                                              wire:model="formDescription" 
                                              rows="3" 
                                              placeholder="Enter form description"></textarea>
                                    @error('formDescription') 
                                        <div class="invalid-feedback">{{ $message }}</div> 
                                    @enderror
                                    <small class="text-muted">Optional description for the form</small>
                                </div>
                                
                                <div class="col-12">
                                    <div class="form-check form-switch d-flex align-items-center">
                                        <input class="form-check-input me-3" 
                                               type="checkbox" 
                                               id="isActive" 
                                               wire:model="isActive">
                                        <label class="form-check-label fw-semibold" for="isActive">
                                            {{-- <i class="fas fa-toggle-on me-1 text-success"></i> --}}Active Form
                                        </label>
                                    </div>
                                    <small class="text-muted">Active forms will be available for use</small>
                                </div>
                            </div>
                        </div>

                        <!-- Form Fields Section -->
                        <div class="form-section">
                            <div class="section-header mb-4">
                                <h6 class="section-title">
                                    <i class="fas fa-list me-2"></i>Form Fields
                                </h6>
                                <div class="section-line"></div>
                            </div>
                            <div class="d-flex justify-content-between align-items-center mb-4">
                                <div class="text-muted">
                                    <i class="fas fa-info-circle me-1"></i>Drag to reorder fields
                                </div>
                                <div class="text-muted">
                                    <i class="fas fa-magic me-1"></i>Field names are auto-generated
                                </div>
                            </div>

                            <!-- Existing Fields -->
                            @foreach($fields as $index => $field)
                                <div class="field-card mb-4" wire:key="field-{{ $index }}">
                                    <div class="field-card-header">
                                        <div class="field-number">{{ $index + 1 }}</div>
                                        <div class="field-info">
                                            <h6 class="field-title">{{ $field['field_label'] ?: 'New Field' }}</h6>
                                        </div>
                                        <div class="field-actions">
                                            <button type="button" class="btn btn-sm btn-outline-danger" wire:click="removeField({{ $index }})">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </div>
                                    <div class="field-card-body">
                                        <div class="row g-3">
                                            <div class="col-md-3">
                                                <label class="form-label">Field Label</label>
                                                <input type="text" 
                                                       class="form-control" 
                                                       wire:model.live="fields.{{ $index }}.field_label"
                                                       placeholder="Field label"
                                                       oninput="updateFieldName({{ $index }}, this.value)">
                                            </div>
                                            <div class="col-md-3 d-none">
                                                <label class="form-label">Field Name</label>
                                                <input type="text" 
                                                       class="form-control" 
                                                       wire:model="fields.{{ $index }}.field_name"
                                                       placeholder="Field name"
                                                       id="field_name_{{ $index }}"
                                                       {{ in_array($field['field_name'], ['first_name', 'last_name', 'email']) ? 'readonly' : '' }}>
                                                @if(in_array($field['field_name'], ['first_name', 'last_name', 'email']))
                                                    <small class="text-muted">Mandatory field</small>
                                                @else
                                                    <small class="text-muted">Auto-generated from label</small>
                                                @endif
                                            </div>
                                            <div class="col-md-3">
                                                <label class="form-label fw-semibold">
                                                    <i class="fas fa-cog me-1 text-primary"></i>Field Type
                                                </label>
                                                <div class="form-control-plaintext field-type-display">
                                                    <span class="field-type-icon">
                                                        @switch($field['field_type'])
                                                            @case('text') 📝 @break
                                                            @case('email') 📧 @break
                                                            @case('number') 🔢 @break
                                                            @case('textarea') 📄 @break
                                                            @case('select') 📋 @break
                                                            @case('checkbox') ☑️ @break
                                                            @case('radio') 🔘 @break
                                                            @case('date') 📅 @break
                                                            @default 📝
                                                        @endswitch
                                                    </span>
                                                    <span class="field-type-text">{{ ucfirst($field['field_type']) }}</span>
                                                    <small class="text-muted d-block">Cannot be changed</small>
                                                </div>
                                            </div>
                                            <div class="col-md-2">
                                                <label class="form-label">Required</label>
                                                <div class="form-check">
                                                    <input class="form-check-input" 
                                                           type="checkbox" 
                                                           wire:model="fields.{{ $index }}.is_required"
                                                           {{ in_array($field['field_name'], ['first_name', 'last_name', 'email']) ? 'checked disabled' : '' }}>
                                                    <label class="form-check-label">Required</label>
                                                </div>
                                            </div>
                                            <div class="col-md-2">
                                                <label class="form-label">Actions</label>
                                                <div class="btn-group w-100" role="group">
                                                    @if($index > 0)
                                                        <button type="button" class="btn btn-sm btn-outline-secondary" wire:click="moveFieldUp({{ $index }})" title="Move Up">
                                                            <i class="fas fa-arrow-up"></i>
                                                        </button>
                                                    @endif
                                                    @if($index < count($fields) - 1)
                                                        <button type="button" class="btn btn-sm btn-outline-secondary" wire:click="moveFieldDown({{ $index }})" title="Move Down">
                                                            <i class="fas fa-arrow-down"></i>
                                                        </button>
                                                    @endif
                                                    @if(!in_array($field['field_name'], ['first_name', 'last_name', 'email']))
                                                        <button type="button" class="btn btn-sm btn-outline-danger" wire:click="removeField({{ $index }})" title="Delete">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    @endif
                                                </div>
                                            </div>
</div>

                                        <!-- Field Options for Select/Radio -->
                                        @if(in_array($field['field_type'], ['select', 'radio']))
                                            <div class="row mt-3">
                                                <div class="col-12">
                                                    <label class="form-label">Options (one per line)</label>
                                                    <textarea class="form-control" 
                                                              rows="3"
                                                              wire:model="fields.{{ $index }}.field_options"
                                                              placeholder="Option 1&#10;Option 2&#10;Option 3"></textarea>
                                                    <small class="text-muted">Enter each option on a new line</small>
                                                </div>
                                            </div>
                                        @endif
                                        
                                        <!-- Placeholder and Help Text -->
                                        <div class="row mt-3">
                                            <div class="col-md-6">
                                                <label class="form-label">Placeholder</label>
                                                <input type="text" 
                                                       class="form-control" 
                                                       wire:model="fields.{{ $index }}.placeholder"
                                                       placeholder="Field placeholder">
                                            </div>
                                            <div class="col-md-6">
                                                <label class="form-label">Help Text</label>
                                                <input type="text" 
                                                       class="form-control" 
                                                       wire:model="fields.{{ $index }}.help_text"
                                                       placeholder="Help text for users">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach

                            <!-- Add New Field -->
                            <div class="add-field-card">
                                <div class="add-field-header">
                                    <h6 class="add-field-title">
                                        <i class="fas fa-plus me-2"></i>Add New Field
                                    </h6>
                                    <p class="add-field-subtitle">Create a new field for your form</p>
                                </div>
                                <div class="add-field-body">
                                    <div class="row g-3">
                                        <div class="col-md-3">
                                            <label class="form-label">Field Label</label>
                                            <input type="text" 
                                                   class="form-control" 
                                                   wire:model.live="newField.field_label"
                                                   placeholder="e.g., Phone Number"
                                                   oninput="updateNewFieldName(this.value)">
                                        </div>
                                        <div class="col-md-3 d-none">
                                            <label class="form-label">Field Name</label>
                                            <input type="text" 
                                                   class="form-control" 
                                                   wire:model="newField.field_name"
                                                   placeholder="e.g., phone_number"
                                                   id="new_field_name">
                                            <small class="text-muted">Auto-generated from label</small>
                                        </div>
                                        <div class="col-md-3">
                                            <label class="form-label fw-semibold">
                                                <i class="fas fa-cog me-1 text-primary"></i>Field Type
                                            </label>
                                            <select class="form-select field-type-select" wire:model="newField.field_type">
                                                <option value="text">📝 Text</option>
                                                <option value="email">📧 Email</option>
                                                <option value="number">🔢 Number</option>
                                                <option value="textarea">📄 Textarea</option>
                                                <option value="select">📋 Dropdown</option>
                                                <option value="checkbox">☑️ Checkbox</option>
                                                <option value="radio">🔘 Radio</option>
                                                <option value="date">📅 Date</option>
                                            </select>
                                        </div>
                                        <div class="col-md-2">
                                            <label class="form-label">Required</label>
                                            <div class="form-check">
                                                <input class="form-check-input" 
                                                       type="checkbox" 
                                                       wire:model="newField.is_required">
                                                <label class="form-check-label">Required</label>
                                            </div>
                                        </div>
                                        <div class="col-md-2">
                                            <label class="form-label">&nbsp;</label>
                                            <button type="button" class="btn btn-primary w-100" wire:click="addField">
                                                <i class="fas fa-plus me-1"></i>Add
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Form Actions -->
                        <div class="row mt-4">
                            <div class="col-12">
                                <div class="d-flex justify-content-end gap-2">
                                    <button type="button" class="btn btn-outline-secondary" wire:click="cancel">
                                        <i class="fas fa-times me-1"></i>Cancel
                                    </button>
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-{{ $editMode ? 'save' : 'plus' }} me-1"></i>
                                        {{ $editMode ? 'Update Form' : 'Create Form' }}
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function generateFieldName(fieldLabel) {
    // Convert field label to snake_case field name
    return fieldLabel
        .toLowerCase()
        .replace(/[^a-zA-Z0-9]+/g, '_')
        .replace(/^_+|_+$/g, '');
}

function updateFieldName(index, fieldLabel) {
    const fieldNameInput = document.getElementById('field_name_' + index);
    if (fieldNameInput && !fieldNameInput.readOnly) {
        fieldNameInput.value = generateFieldName(fieldLabel);
        // Trigger Livewire update
        fieldNameInput.dispatchEvent(new Event('input', { bubbles: true }));
    }
}

function updateNewFieldName(fieldLabel) {
    const fieldNameInput = document.getElementById('new_field_name');
    if (fieldNameInput) {
        fieldNameInput.value = generateFieldName(fieldLabel);
        // Trigger Livewire update
        fieldNameInput.dispatchEvent(new Event('input', { bubbles: true }));
    }
}

// Listen for Livewire events to clear new field inputs
document.addEventListener('livewire:init', () => {
    Livewire.on('field-added', () => {
        // Clear the new field inputs after adding a field
        const newFieldLabelInput = document.querySelector('input[wire\\:model\\.live="newField.field_label"]');
        const newFieldNameInput = document.getElementById('new_field_name');
        
        if (newFieldLabelInput) newFieldLabelInput.value = '';
        if (newFieldNameInput) newFieldNameInput.value = '';
    });
});
</script>