<div class="container-fluid px-4 py-3">
    <!-- Page Header -->
    <div class="page-header-clean">
        <div class="row align-items-center">
            <div class="col">
                <div class="d-flex align-items-center mb-3">
                    <h1 class="page-title-clean me-3">
                        <i class="fas fa-user me-2"></i>
                        Profile
                    </h1>
                </div>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb breadcrumb-clean">
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.dashboard') }}">
                                <i class="fas fa-home me-1"></i>Dashboard
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            <i class="fas fa-user me-1"></i>
                            Profile
                        </li>
                    </ol>
                </nav>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Profile Information -->
        <div class="col-lg-8">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-user-edit me-2"></i>Profile Information
                    </h5>
                </div>
                <div class="card-body">
                    <form wire:submit.prevent="updateProfile">

                        <!-- Basic Information -->
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label for="name" class="form-label">Full Name *</label>
                                <input type="text" 
                                       class="form-control @error('name') is-invalid @enderror" 
                                       id="name" 
                                       wire:model="name" 
                                       placeholder="Enter your full name">
                                @error('name') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                            <div class="col-md-6">
                                <label for="email" class="form-label">Email Address *</label>
                                <input type="email" 
                                       class="form-control @error('email') is-invalid @enderror" 
                                       id="email" 
                                       wire:model="email" 
                                       placeholder="Enter your email">
                                @error('email') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                            <div class="col-md-6">
                                <label for="phone" class="form-label">Phone Number</label>
                                <input type="tel" 
                                       class="form-control @error('phone') is-invalid @enderror" 
                                       id="phone" 
                                       wire:model="phone" 
                                       placeholder="Enter your phone number">
                                @error('phone') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                            <div class="col-md-6">
                                <label for="date_of_birth" class="form-label">Date of Birth</label>
                                <input type="date" 
                                       class="form-control @error('date_of_birth') is-invalid @enderror" 
                                       id="date_of_birth" 
                                       wire:model="date_of_birth" 
                                       max="{{ date('Y-m-d') }}">
                                @error('date_of_birth') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                            <div class="col-12">
                                <label for="address" class="form-label">Address</label>
                                <textarea class="form-control @error('address') is-invalid @enderror" 
                                          id="address" 
                                          wire:model="address" 
                                          rows="3" 
                                          placeholder="Enter your address"></textarea>
                                @error('address') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                        </div>

                        <div class="mt-4">
                            <button type="submit" class="btn btn-primary" wire:loading.attr="disabled">
                                <span wire:loading.remove wire:target="updateProfile">
                                    <i class="fas fa-save me-2"></i>Update Profile
                                </span>
                                <span wire:loading wire:target="updateProfile">
                                    <i class="fas fa-spinner fa-spin me-2"></i>Updating...
                                </span>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Password Change -->
        <div class="col-lg-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-lock me-2"></i>Change Password
                    </h5>
                </div>
                <div class="card-body">
                    <form wire:submit.prevent="updatePassword">
                        <div class="mb-3">
                            <label for="current_password" class="form-label">Current Password *</label>
                            <input type="password" 
                                   class="form-control @error('current_password') is-invalid @enderror" 
                                   id="current_password" 
                                   wire:model="current_password" 
                                   placeholder="Enter current password">
                            @error('current_password') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                        <div class="mb-3">
                            <label for="new_password" class="form-label">New Password *</label>
                            <input type="password" 
                                   class="form-control @error('new_password') is-invalid @enderror" 
                                   id="new_password" 
                                   wire:model="new_password" 
                                   placeholder="Enter new password">
                            @error('new_password') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                        <div class="mb-3">
                            <label for="new_password_confirmation" class="form-label">Confirm New Password *</label>
                            <input type="password" 
                                   class="form-control @error('new_password_confirmation') is-invalid @enderror" 
                                   id="new_password_confirmation" 
                                   wire:model="new_password_confirmation" 
                                   placeholder="Confirm new password">
                            @error('new_password_confirmation') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                        <button type="submit" class="btn btn-warning w-100" wire:loading.attr="disabled">
                            <span wire:loading.remove wire:target="updatePassword">
                                <i class="fas fa-key me-2"></i>Change Password
                            </span>
                            <span wire:loading wire:target="updatePassword">
                                <i class="fas fa-spinner fa-spin me-2"></i>Changing...
                            </span>
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>