<div class="container-fluid px-4 py-3">
    <!-- Page Header -->
    <div class="page-header-two-row">
        <div class="page-title-row">
            <h1 class="page-title-two-row">
                <i class="fas fa-{{ $editMode ? 'edit' : 'plus' }}"></i>
                {{ $editMode ? 'Edit Question' : 'Create New Question' }}
            </h1>
        </div>
        <div class="page-actions-row">
            <div class="breadcrumb-section">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.dashboard') }}">
                                <i class="fas fa-home me-1"></i>Dashboard
                            </a>
                        </li>
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.quizzes') }}">
                                <i class="fas fa-clipboard me-1"></i>Quizzes
                            </a>
                        </li>
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.quizzes.show', $quiz) }}">
                                <i class="fas fa-eye me-1"></i>{{ $quiz->title }}
                            </a>
                        </li>
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.quizzes.questions', $quiz) }}">
                                <i class="fas fa-question-circle me-1"></i>Questions
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            {{ $editMode ? 'Edit Question' : 'Create Question' }}
                        </li>
                    </ol>
                </nav>
            </div>
        </div>
    </div>

    <!-- Question Form -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-info-circle me-2"></i>Question Details
                    </h5>
                </div>
                <div class="card-body">
                    <!-- Flash Messages -->
                    @if (session()->has('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif

                    @if (session()->has('error'))
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <i class="fas fa-exclamation-circle me-2"></i>{{ session('error') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif

                    <form wire:submit.prevent="save" wire:loading.attr="disabled">
                        <div class="row g-3">
                            <!-- Question Type -->
                            <div class="col-md-6">
                                <label for="questionType" class="form-label">Question Type <span class="text-danger">*</span></label>
                                <select class="form-select @error('questionType') is-invalid @enderror" 
                                        id="questionType" 
                                        wire:model.live="questionType">
                                    @foreach($questionTypes as $key => $label)
                                        <option value="{{ $key }}">{{ $label }}</option>
                                    @endforeach
                                </select>
                                @error('questionType') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>

                            <!-- Score Points -->
                            <div class="col-md-6">
                                <label for="scorePoints" class="form-label">Score Points <span class="text-danger">*</span></label>
                                <input type="number" 
                                       class="form-control @error('scorePoints') is-invalid @enderror" 
                                       id="scorePoints" 
                                       wire:model="scorePoints" 
                                       step="0.1" 
                                       min="0.1" 
                                       max="100">
                                @error('scorePoints') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>

                            <!-- Question Text -->
                            <div class="col-12">
                                <label for="questionText" class="form-label">Question Text <span class="text-danger">*</span></label>
                                <textarea class="form-control @error('questionText') is-invalid @enderror" 
                                          id="questionText" 
                                          wire:model="questionText" 
                                          rows="4" 
                                          placeholder="Enter your question here..."></textarea>
                                @error('questionText') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>

                            <!-- Question Options -->
                            @if(in_array($questionType, ['MULTIPLE_CHOICE', 'TRUE_FALSE', 'ORDER']))
                            <div class="col-12">
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <h6 class="fw-bold text-primary mb-0">Options</h6>
                                    <button type="button" class="btn btn-sm btn-outline-primary" wire:click="addOption">
                                        <i class="fas fa-plus me-1"></i>Add Option
                                    </button>
</div>

                                @foreach($options as $index => $option)
                                <div class="input-group mb-2">
                                    <span class="input-group-text">{{ $index + 1 }}</span>
                                    <input type="text" 
                                           class="form-control" 
                                           wire:model="options.{{ $index }}.text" 
                                           placeholder="Enter option text...">
                                    @if($questionType === 'MULTIPLE_CHOICE')
                                        <div class="input-group-text">
                                            <div class="form-check">
                                                <input class="form-check-input" 
                                                       type="checkbox" 
                                                       wire:model="options.{{ $index }}.is_correct">
                                                <label class="form-check-label">Correct</label>
                                            </div>
                                        </div>
                                    @endif
                                    @if(count($options) > 2)
                                        <button type="button" 
                                                class="btn btn-outline-danger" 
                                                wire:click="removeOption({{ $index }})">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    @endif
                                </div>
                                @endforeach
                            </div>
                            @endif

                            <!-- Matching Question Options -->
                            @if($questionType === 'MATCH')
                            <div class="col-12">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="d-flex justify-content-between align-items-center mb-3">
                                            <h6 class="fw-bold text-primary mb-0">Left Items</h6>
                                            <button type="button" class="btn btn-sm btn-outline-primary" wire:click="addOption">
                                                <i class="fas fa-plus me-1"></i>Add Item
                                            </button>
                                        </div>
                                        @foreach($options['left_items'] as $index => $item)
                                        <div class="input-group mb-2">
                                            <span class="input-group-text">{{ $index + 1 }}</span>
                                            <input type="text" 
                                                   class="form-control" 
                                                   wire:model="options.left_items.{{ $index }}.text" 
                                                   placeholder="Enter left item...">
                                            @if(count($options['left_items']) > 2)
                                                <button type="button" 
                                                        class="btn btn-outline-danger" 
                                                        wire:click="removeOption({{ $index }})">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            @endif
                                        </div>
                                        @endforeach
                                    </div>
                                    <div class="col-md-6">
                                        <div class="d-flex justify-content-between align-items-center mb-3">
                                            <h6 class="fw-bold text-primary mb-0">Right Items</h6>
                                            <button type="button" class="btn btn-sm btn-outline-primary" wire:click="addOption">
                                                <i class="fas fa-plus me-1"></i>Add Item
                                            </button>
                                        </div>
                                        @foreach($options['right_items'] as $index => $item)
                                        <div class="input-group mb-2">
                                            <span class="input-group-text">{{ $index + 1 }}</span>
                                            <input type="text" 
                                                   class="form-control" 
                                                   wire:model="options.right_items.{{ $index }}.text" 
                                                   placeholder="Enter right item...">
                                            @if(count($options['right_items']) > 2)
                                                <button type="button" 
                                                        class="btn btn-outline-danger" 
                                                        wire:click="removeOption({{ $index }})">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            @endif
                                        </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                            @endif

                            <!-- Matrix Question Options -->
                            @if($questionType === 'MATRIX')
                            <div class="col-12">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="d-flex justify-content-between align-items-center mb-3">
                                            <h6 class="fw-bold text-primary mb-0">Rows</h6>
                                            <button type="button" class="btn btn-sm btn-outline-primary" wire:click="addOption">
                                                <i class="fas fa-plus me-1"></i>Add Row
                                            </button>
                                        </div>
                                        @foreach($options['rows'] as $index => $row)
                                        <div class="input-group mb-2">
                                            <span class="input-group-text">{{ $index + 1 }}</span>
                                            <input type="text" 
                                                   class="form-control" 
                                                   wire:model="options.rows.{{ $index }}.text" 
                                                   placeholder="Enter row label...">
                                            @if(count($options['rows']) > 2)
                                                <button type="button" 
                                                        class="btn btn-outline-danger" 
                                                        wire:click="removeOption({{ $index }})">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            @endif
                                        </div>
                                        @endforeach
                                    </div>
                                    <div class="col-md-6">
                                        <div class="d-flex justify-content-between align-items-center mb-3">
                                            <h6 class="fw-bold text-primary mb-0">Columns</h6>
                                            <button type="button" class="btn btn-sm btn-outline-primary" wire:click="addOption">
                                                <i class="fas fa-plus me-1"></i>Add Column
                                            </button>
                                        </div>
                                        @foreach($options['columns'] as $index => $column)
                                        <div class="input-group mb-2">
                                            <span class="input-group-text">{{ $index + 1 }}</span>
                                            <input type="text" 
                                                   class="form-control" 
                                                   wire:model="options.columns.{{ $index }}.text" 
                                                   placeholder="Enter column label...">
                                            @if(count($options['columns']) > 2)
                                                <button type="button" 
                                                        class="btn btn-outline-danger" 
                                                        wire:click="removeOption({{ $index }})">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            @endif
                                        </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                            @endif

                            <!-- Correct Answer -->
                            @if(in_array($questionType, ['FILL_BLANK', 'SHORT_ANSWER', 'ESSAY', 'DATE', 'CODE', 'NUMERIC']))
                            <div class="col-12">
                                <h6 class="fw-bold text-primary mb-3">Correct Answer</h6>
                                @if($questionType === 'FILL_BLANK' || $questionType === 'SHORT_ANSWER')
                                    <input type="text" 
                                           class="form-control" 
                                           wire:model="correctAnswer.text" 
                                           placeholder="Enter correct answer...">
                                @elseif($questionType === 'ESSAY')
                                    <textarea class="form-control" 
                                              wire:model="correctAnswer.text" 
                                              rows="3" 
                                              placeholder="Enter sample answer or grading criteria..."></textarea>
                                @elseif($questionType === 'DATE')
                                    <input type="date" 
                                           class="form-control" 
                                           wire:model="correctAnswer.date">
                                @elseif($questionType === 'CODE')
                                    <textarea class="form-control" 
                                              wire:model="correctAnswer.code" 
                                              rows="5" 
                                              placeholder="Enter sample code..."></textarea>
                                @elseif($questionType === 'NUMERIC')
                                    <input type="number" 
                                           class="form-control" 
                                           wire:model="correctAnswer.value" 
                                           step="0.01" 
                                           placeholder="Enter correct numeric value...">
                                @endif
                            </div>
                            @endif

                            <!-- Feedback -->
                            <div class="col-12">
                                <label for="feedback" class="form-label">Feedback</label>
                                <textarea class="form-control" 
                                          id="feedback" 
                                          wire:model="feedback" 
                                          rows="3" 
                                          placeholder="Enter feedback for students (optional)..."></textarea>
                            </div>

                            <!-- Settings -->
                            <div class="col-12">
                                <h6 class="fw-bold text-primary border-bottom pb-2 mb-3">Question Settings</h6>
                            </div>

                            <div class="col-md-6">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" 
                                           type="checkbox" 
                                           id="isRequired" 
                                           wire:model="isRequired">
                                    <label class="form-check-label" for="isRequired">
                                        Required Question
                                    </label>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" 
                                           type="checkbox" 
                                           id="isActive" 
                                           wire:model="isActive">
                                    <label class="form-check-label" for="isActive">
                                        Active
                                    </label>
                                </div>
                            </div>

                            <!-- Order -->
                            <div class="col-md-6">
                                <label for="order" class="form-label">Order</label>
                                <input type="number" 
                                       class="form-control" 
                                       id="order" 
                                       wire:model="order" 
                                       min="1">
                            </div>
                        </div>

                        <!-- Form Actions -->
                        <div class="row mt-4">
                            <div class="col-12">
                                <div class="d-flex justify-content-end gap-2">
                                    <button type="button" 
                                            class="btn btn-outline-secondary" 
                                            wire:click="cancel">
                                        <i class="fas fa-times me-1"></i>Cancel
                                    </button>
                                    <button type="submit" 
                                            class="btn btn-primary"
                                            wire:loading.attr="disabled"
                                            wire:target="save">
                                        <span wire:loading.remove wire:target="save">
                                            <i class="fas fa-save me-1"></i>{{ $editMode ? 'Update Question' : 'Create Question' }}
                                        </span>
                                        <span wire:loading wire:target="save">
                                            <i class="fas fa-spinner fa-spin me-1"></i>Saving...
                                        </span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>