<div>
    <!-- Header Section -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h4 class="mb-1">Quiz Invitations</h4>
            <p class="text-muted mb-0">Manage invitations for "{{ $quiz->title }}"</p>
        </div>
        <div>
            <button type="button" class="btn btn-primary" wire:click="toggleInviteForm">
                <i class="fas fa-envelope me-2"></i>Send Invitations
            </button>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-md-2">
            <div class="card bg-primary text-white">
                <div class="card-body text-center">
                    <h3 class="mb-1">{{ $stats['total'] }}</h3>
                    <small>Total</small>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="card bg-warning text-white">
                <div class="card-body text-center">
                    <h3 class="mb-1">{{ $stats['pending'] }}</h3>
                    <small>Pending</small>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="card bg-info text-white">
                <div class="card-body text-center">
                    <h3 class="mb-1">{{ $stats['sent'] }}</h3>
                    <small>Sent</small>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="card bg-secondary text-white">
                <div class="card-body text-center">
                    <h3 class="mb-1">{{ $stats['opened'] }}</h3>
                    <small>Opened</small>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="card bg-success text-white">
                <div class="card-body text-center">
                    <h3 class="mb-1">{{ $stats['completed'] }}</h3>
                    <small>Completed</small>
                </div>
            </div>
        </div>
    </div>

    <!-- Invitation Form Modal -->
    @if($showInviteForm)
    <div class="card mb-4">
        <div class="card-header">
            <h5 class="mb-0">Send New Invitations</h5>
        </div>
        <div class="card-body">
            <form wire:submit.prevent="sendInvitations">
                <div class="mb-3">
                    <label for="emails" class="form-label">Email Addresses</label>
                    <textarea 
                        class="form-control @error('emails') is-invalid @enderror" 
                        id="emails" 
                        rows="3" 
                        wire:model="emails"
                        placeholder="Enter email addresses separated by commas (e.g., user1@example.com, user2@example.com)"
                    ></textarea>
                    @error('emails') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    <div class="form-text">Separate multiple email addresses with commas</div>
                </div>

                <div class="mb-3">
                    <label for="customMessage" class="form-label">Personal Message (Optional)</label>
                    <textarea 
                        class="form-control @error('customMessage') is-invalid @enderror" 
                        id="customMessage" 
                        rows="3" 
                        wire:model="customMessage"
                        placeholder="Add a personal message to include in the invitation email"
                    ></textarea>
                    @error('customMessage') <div class="invalid-feedback">{{ $message }}</div> @enderror
                </div>

                <div class="d-flex gap-2">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-paper-plane me-2"></i>Send Invitations
                    </button>
                    <button type="button" class="btn btn-secondary" wire:click="toggleInviteForm">
                        <i class="fas fa-times me-2"></i>Cancel
                    </button>
                </div>
            </form>
        </div>
    </div>
    @endif

    <!-- Filters and Search -->
    <div class="card mb-4">
        <div class="card-body">
            <div class="row g-3">
                <div class="col-md-4">
                    <input 
                        type="text" 
                        class="form-control" 
                        placeholder="Search by email..." 
                        wire:model.live.debounce.300ms="search"
                    >
                </div>
                <div class="col-md-3">
                    <select class="form-select" wire:model.live="statusFilter">
                        <option value="">All Statuses</option>
                        <option value="pending">Pending</option>
                        <option value="sent">Sent</option>
                        <option value="opened">Opened</option>
                        <option value="completed">Completed</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <select class="form-select" wire:model.live="sortField">
                        <option value="created_at">Sort by Date</option>
                        <option value="email">Sort by Email</option>
                        <option value="status">Sort by Status</option>
                        <option value="sent_at">Sort by Sent Date</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <button type="button" class="btn btn-outline-secondary w-100" wire:click="clearFilters">
                        <i class="fas fa-times me-2"></i>Clear
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Invitations Table -->
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Invitations</h5>
            @if(count($selectedInvitations) > 0)
                <button type="button" class="btn btn-danger btn-sm" wire:click="bulkDelete">
                    <i class="fas fa-trash me-2"></i>Delete Selected ({{ count($selectedInvitations) }})
                </button>
            @endif
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead class="table-light">
                        <tr>
                            <th>
                                <input 
                                    type="checkbox" 
                                    class="form-check-input" 
                                    wire:click="toggleSelectAll"
                                    @if(count($selectedInvitations) === $invitations->count() && $invitations->count() > 0) checked @endif
                                >
                            </th>
                            <th>
                                <a href="#" wire:click="sortBy('email')" class="text-decoration-none">
                                    Email
                                    @if($sortField === 'email')
                                        <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }} ms-1"></i>
                                    @endif
                                </a>
                            </th>
                            <th>
                                <a href="#" wire:click="sortBy('status')" class="text-decoration-none">
                                    Status
                                    @if($sortField === 'status')
                                        <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }} ms-1"></i>
                                    @endif
                                </a>
                            </th>
                            <th>
                                <a href="#" wire:click="sortBy('sent_at')" class="text-decoration-none">
                                    Sent Date
                                    @if($sortField === 'sent_at')
                                        <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }} ms-1"></i>
                                    @endif
                                </a>
                            </th>
                            <th>
                                <a href="#" wire:click="sortBy('opened_at')" class="text-decoration-none">
                                    Opened Date
                                    @if($sortField === 'opened_at')
                                        <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }} ms-1"></i>
                                    @endif
                                </a>
                            </th>
                            <th>
                                <a href="#" wire:click="sortBy('completed_at')" class="text-decoration-none">
                                    Completed Date
                                    @if($sortField === 'completed_at')
                                        <i class="fas fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }} ms-1"></i>
                                    @endif
                                </a>
                            </th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($invitations as $invitation)
                            <tr>
                                <td>
                                    <input 
                                        type="checkbox" 
                                        class="form-check-input" 
                                        value="{{ $invitation->id }}"
                                        wire:model="selectedInvitations"
                                    >
                                </td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <i class="fas fa-envelope me-2 text-muted"></i>
                                        {{ $invitation->email }}
                                    </div>
                                </td>
                                <td>
                                    @php
                                        $statusConfig = [
                                            'pending' => ['class' => 'bg-warning', 'text' => 'Pending'],
                                            'sent' => ['class' => 'bg-info', 'text' => 'Sent'],
                                            'opened' => ['class' => 'bg-secondary', 'text' => 'Opened'],
                                            'completed' => ['class' => 'bg-success', 'text' => 'Completed'],
                                        ];
                                        $config = $statusConfig[$invitation->status] ?? ['class' => 'bg-light', 'text' => ucfirst($invitation->status)];
                                    @endphp
                                    <span class="badge {{ $config['class'] }}">{{ $config['text'] }}</span>
                                </td>
                                <td>
                                    @if($invitation->sent_at)
                                        {{ $invitation->sent_at->format('M j, Y g:i A') }}
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                                <td>
                                    @if($invitation->opened_at)
                                        {{ $invitation->opened_at->format('M j, Y g:i A') }}
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                                <td>
                                    @if($invitation->completed_at)
                                        {{ $invitation->completed_at->format('M j, Y g:i A') }}
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                                <td>
                                    <div class="btn-group btn-group-sm">
                                        @if($invitation->status !== 'completed')
                                            <button 
                                                type="button" 
                                                class="btn btn-outline-primary" 
                                                wire:click="resendInvitation({{ $invitation->id }})"
                                                title="Resend Invitation"
                                            >
                                                <i class="fas fa-paper-plane"></i>
                                            </button>
                                        @endif
                                        <button 
                                            type="button" 
                                            class="btn btn-outline-danger" 
                                            wire:click="deleteInvitation({{ $invitation->id }})"
                                            onclick="return confirm('Are you sure you want to delete this invitation?')"
                                            title="Delete Invitation"
                                        >
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center py-4">
                                    <div class="text-muted">
                                        <i class="fas fa-inbox fa-3x mb-3"></i>
                                        <p class="mb-0">No invitations found</p>
                                        <small>Send your first invitation using the button above</small>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        @if($invitations->hasPages())
            <div class="card-footer">
                {{ $invitations->links() }}
            </div>
        @endif
    </div>
</div>
