<div class="container-fluid px-4 py-3">
    <!-- Page Header -->
    <div class="page-header-two-row">
        <div class="page-title-row">
            <h1 class="page-title-two-row">
                <i class="fas fa-user-tag"></i>
                {{ $editMode ? 'Edit Role' : 'Add New Role' }}
            </h1>
        </div>
        <div class="page-actions-row">
            <div class="breadcrumb-section">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.dashboard') }}">
                                <i class="fas fa-home me-1"></i>Dashboard
                            </a>
                        </li>
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.roles') }}">
                                <i class="fas fa-user-tag me-1"></i>Roles
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            <i class="fas fa-{{ $editMode ? 'edit' : 'plus' }} me-1"></i>
                            {{ $editMode ? 'Edit Role' : 'Add Role' }}
                        </li>
                    </ol>
                </nav>
            </div>
            <div class="action-section">
                <a href="{{ route('admin.roles') }}" class="btn btn-outline-secondary">
                    <i class="fas fa-arrow-left me-2"></i>Back to Roles
                </a>
            </div>
        </div>
    </div>

    <!-- Role Form -->
    <div class="container-fluid">
        <div class="row justify-content-center">
            <div class="col-12 col-xl-10 col-lg-11">
                <div class="card user-form-card shadow-sm">
                    <div class="card-header user-form-header-clean">
                        <div class="row align-items-center">
                            <div class="col">
                                <h5 class="card-title-clean mb-0">
                                    <i class="fas fa-user-tag me-2"></i>
                                    {{ $editMode ? 'Edit Role Information' : 'Create New Role' }}
                                </h5>
                                <p class="card-subtitle-clean mb-0 mt-1">
                                    {{ $editMode ? 'Update role details and permissions' : 'Fill in the information below to create a new role' }}
                                </p>
                            </div>
                        </div>
                    </div>

                    <div class="card-body user-form-body">
                        <form wire:submit.prevent="save" id="roleForm">
                            <!-- Role Information -->
                            <div class="form-section mb-4">
                                <h6 class="form-section-title">
                                    <i class="fas fa-user-tag me-2"></i>Role Information
                                </h6>
                                <div class="row g-3">
                                    <div class="col-12">
                                        <label for="name" class="form-label user-form-label">
                                            <i class="fas fa-tag me-1"></i>Role Name *
                                        </label>
                                        <input type="text"
                                               class="form-control user-form-control @error('name') is-invalid @enderror"
                                               id="name"
                                               wire:model="name"
                                               placeholder="Enter role name"
                                               autocomplete="off"
                                               {{ $editMode && $name === 'Owner' ? 'readonly' : '' }}
                                               required>
                                        @error('name')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                        @if($editMode && $name === 'Owner')
                                            <div class="form-text text-warning">
                                                <i class="fas fa-shield-alt me-1"></i>
                                                This is a protected role and cannot be renamed.
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <!-- Permissions -->
                            <div class="form-section">
                                <h6 class="form-section-title mt-3">
                                    <i class="fas fa-key me-2"></i>Permissions
                                </h6>
                                <div class="row">
                                    @foreach($permissions as $category => $categoryPermissions)
                                    <div class="col-md-6 col-lg-4 mb-4">
                                        <div class="permission-category">
                                            <h6 class="permission-category-title">
                                                <i class="fas fa-folder me-2"></i>
                                                {{ ucfirst(str_replace('_', ' ', $category)) }}
                                            </h6>
                                            <div class="permission-list">
                                                @foreach($categoryPermissions as $permission)
                                                <div class="form-check">
                                                    <input class="form-check-input" 
                                                           type="checkbox" 
                                                           value="{{ $permission->id }}"
                                                           id="permission-{{ $permission->id }}"
                                                           wire:model.live="selectedPermissions">
                                                    <label class="form-check-label" for="permission-{{ $permission->id }}">
                                                        {{ ucfirst(str_replace(['.', '_'], [' ', ' '], $permission->name)) }}
                                                    </label>
                                                </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                </div>
                            </div>
                        </form>
                    </div>

                    <div class="card-footer user-form-footer">
                        <div class="row">
                            <div class="col-12">
                                <div class="d-flex flex-column flex-md-row justify-content-between gap-2">
                                    <button type="button" class="btn btn-secondary user-form-btn" wire:click="cancel">
                                        <i class="fas fa-times me-2"></i>Cancel
                                    </button>
                                    <button type="button" class="btn btn-primary user-form-btn" wire:click="save" wire:loading.attr="disabled">
                                        <span wire:loading.remove wire:target="save">
                                            <i class="fas fa-{{ $editMode ? 'save' : 'plus' }} me-2"></i>
                                            {{ $editMode ? 'Update Role' : 'Create Role' }}
                                        </span>
                                        <span wire:loading wire:target="save">
                                            <i class="fas fa-spinner fa-spin me-2"></i>Processing...
                                        </span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
