<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $quiz->title }} - Quiz Attempt</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .quiz-container {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 20px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            min-height: 80vh;
        }
        .quiz-header {
            background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
            color: white;
            border-radius: 20px 20px 0 0;
            padding: 1.5rem;
        }
        .question-card {
            background: white;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
            margin-bottom: 2rem;
            overflow: hidden;
        }
        .question-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 1rem 1.5rem;
        }
        .question-body {
            padding: 2rem;
        }
        .option-item {
            background: #f8f9fa;
            border: 2px solid #e9ecef;
            border-radius: 10px;
            padding: 1rem;
            margin-bottom: 1rem;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        .option-item:hover {
            background: #e3f2fd;
            border-color: #2196f3;
        }
        .option-item.selected {
            background: #e3f2fd;
            border-color: #2196f3;
        }
        .timer {
            background: linear-gradient(135deg, #ff6b6b 0%, #ee5a52 100%);
            color: white;
            padding: 0.5rem 1rem;
            border-radius: 25px;
            font-weight: 600;
        }
        .progress-bar {
            height: 8px;
            border-radius: 4px;
            background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
        }
        .btn-quiz {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 50px;
            padding: 12px 30px;
            font-weight: 600;
            color: white;
            transition: all 0.3s ease;
        }
        .btn-quiz:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(102, 126, 234, 0.4);
            color: white;
        }
        .btn-outline-quiz {
            border: 2px solid #667eea;
            color: #667eea;
            border-radius: 50px;
            padding: 12px 30px;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        .btn-outline-quiz:hover {
            background: #667eea;
            color: white;
        }
    </style>
</head>
<body>
    <div class="container-fluid py-4">
        <div class="row">
            <div class="col-12">
                <div class="quiz-container">
                    <!-- Quiz Header -->
                    <div class="quiz-header">
                        <div class="row align-items-center">
                            <div class="col-md-6">
                                <h2 class="mb-1">{{ $quiz->title }}</h2>
                                <p class="mb-0">Question <span id="current-question">1</span> of {{ $quiz->total_questions }}</p>
                            </div>
                            <div class="col-md-6 text-md-end">
                                <div class="d-flex justify-content-md-end gap-3 align-items-center">
                                    @if($quiz->duration_minutes)
                                        <div class="timer">
                                            <i class="fas fa-clock me-2"></i>
                                            <span id="timer">{{ $quiz->duration_minutes }}:00</span>
                                        </div>
                                    @endif
                                    <div class="text-white">
                                        <i class="fas fa-user me-2"></i>{{ Auth::user()->name }}
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Progress Bar -->
                        <div class="mt-3">
                            <div class="progress" style="height: 8px;">
                                <div class="progress-bar" id="progress-bar" style="width: 0%"></div>
                            </div>
                        </div>
                    </div>

                    <!-- Quiz Content -->
                    <div class="p-4">
                        <form id="quiz-form" method="POST" action="{{ route('quiz.submit', ['quiz' => $quiz->unique_url, 'token' => $invitation->token]) }}">
                            @csrf
                            
                            <!-- Questions Container -->
                            <div id="questions-container">
                                @foreach($quiz->questions as $index => $question)
                                    <div class="question-card question-item" data-question="{{ $index + 1 }}" style="{{ $index > 0 ? 'display: none;' : '' }}">
                                        <div class="question-header">
                                            <h5 class="mb-0">
                                                <span class="badge bg-light text-dark me-2">{{ $index + 1 }}</span>
                                                {{ $question->question_text }}
                                            </h5>
                                            @if($question->is_required)
                                                <small class="text-warning">
                                                    <i class="fas fa-asterisk me-1"></i>Required Question
                                                </small>
                                            @endif
                                        </div>
                                        <div class="question-body">
                                            @if($question->type === 'multiple_choice')
                                                @foreach($question->question_data['options'] as $optionIndex => $option)
                                                    <div class="option-item" onclick="selectOption(this, '{{ $question->id }}', '{{ $optionIndex }}')">
                                                        <div class="form-check">
                                                            <input class="form-check-input" type="radio" 
                                                                   name="question_{{ $question->id }}" 
                                                                   value="{{ $optionIndex }}" 
                                                                   id="q{{ $question->id }}_o{{ $optionIndex }}">
                                                            <label class="form-check-label w-100" for="q{{ $question->id }}_o{{ $optionIndex }}">
                                                                {{ $option['text'] }}
                                                            </label>
                                                        </div>
                                                    </div>
                                                @endforeach
                                            @elseif($question->type === 'true_false')
                                                <div class="option-item" onclick="selectOption(this, '{{ $question->id }}', 'true')">
                                                    <div class="form-check">
                                                        <input class="form-check-input" type="radio" 
                                                               name="question_{{ $question->id }}" 
                                                               value="true" 
                                                               id="q{{ $question->id }}_true">
                                                        <label class="form-check-label w-100" for="q{{ $question->id }}_true">
                                                            True
                                                        </label>
                                                    </div>
                                                </div>
                                                <div class="option-item" onclick="selectOption(this, '{{ $question->id }}', 'false')">
                                                    <div class="form-check">
                                                        <input class="form-check-input" type="radio" 
                                                               name="question_{{ $question->id }}" 
                                                               value="false" 
                                                               id="q{{ $question->id }}_false">
                                                        <label class="form-check-label w-100" for="q{{ $question->id }}_false">
                                                            False
                                                        </label>
                                                    </div>
                                                </div>
                                            @elseif($question->type === 'short_answer')
                                                <div class="form-group">
                                                    <input type="text" 
                                                           class="form-control form-control-lg" 
                                                           name="question_{{ $question->id }}" 
                                                           placeholder="Enter your answer here..."
                                                           id="q{{ $question->id }}_answer">
                                                </div>
                                            @elseif($question->type === 'essay')
                                                <div class="form-group">
                                                    <textarea class="form-control" 
                                                              name="question_{{ $question->id }}" 
                                                              rows="5" 
                                                              placeholder="Enter your detailed answer here..."
                                                              id="q{{ $question->id }}_answer"></textarea>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                @endforeach
                            </div>

                            <!-- Navigation Buttons -->
                            <div class="d-flex justify-content-between mt-4">
                                <button type="button" class="btn btn-outline-quiz" id="prev-btn" onclick="previousQuestion()" style="display: none;">
                                    <i class="fas fa-arrow-left me-2"></i>Previous
                                </button>
                                <div class="ms-auto">
                                    <button type="button" class="btn btn-quiz" id="next-btn" onclick="nextQuestion()">
                                        Next<i class="fas fa-arrow-right ms-2"></i>
                                    </button>
                                    <button type="submit" class="btn btn-success ms-2" id="submit-btn" style="display: none;">
                                        <i class="fas fa-check me-2"></i>Submit Quiz
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        let currentQuestion = 1;
        const totalQuestions = {{ $quiz->total_questions }};
        const timeLimit = {{ $quiz->duration_minutes ? $quiz->duration_minutes * 60 : 0 }};
        let timeLeft = timeLimit;
        let timerInterval;

        // Timer functionality
        @if($quiz->duration_minutes)
        function startTimer() {
            timerInterval = setInterval(function() {
                timeLeft--;
                const minutes = Math.floor(timeLeft / 60);
                const seconds = timeLeft % 60;
                document.getElementById('timer').textContent = 
                    minutes.toString().padStart(2, '0') + ':' + seconds.toString().padStart(2, '0');
                
                if (timeLeft <= 0) {
                    clearInterval(timerInterval);
                    alert('Time\'s up! Your quiz will be submitted automatically.');
                    document.getElementById('quiz-form').submit();
                }
            }, 1000);
        }

        startTimer();
        @endif

        function selectOption(element, questionId, value) {
            // Remove selected class from all options in this question
            const questionCard = element.closest('.question-item');
            questionCard.querySelectorAll('.option-item').forEach(item => {
                item.classList.remove('selected');
            });
            
            // Add selected class to clicked option
            element.classList.add('selected');
            
            // Check the radio button
            const radio = element.querySelector('input[type="radio"]');
            if (radio) {
                radio.checked = true;
            }
        }

        function showQuestion(questionNumber) {
            // Hide all questions
            document.querySelectorAll('.question-item').forEach(item => {
                item.style.display = 'none';
            });
            
            // Show current question
            document.querySelector(`[data-question="${questionNumber}"]`).style.display = 'block';
            
            // Update current question display
            document.getElementById('current-question').textContent = questionNumber;
            
            // Update progress bar
            const progress = (questionNumber / totalQuestions) * 100;
            document.getElementById('progress-bar').style.width = progress + '%';
            
            // Update navigation buttons
            document.getElementById('prev-btn').style.display = questionNumber > 1 ? 'block' : 'none';
            document.getElementById('next-btn').style.display = questionNumber < totalQuestions ? 'block' : 'none';
            document.getElementById('submit-btn').style.display = questionNumber === totalQuestions ? 'block' : 'none';
        }

        function nextQuestion() {
            if (currentQuestion < totalQuestions) {
                currentQuestion++;
                showQuestion(currentQuestion);
            }
        }

        function previousQuestion() {
            if (currentQuestion > 1) {
                currentQuestion--;
                showQuestion(currentQuestion);
            }
        }

        // Form submission
        document.getElementById('quiz-form').addEventListener('submit', function(e) {
            e.preventDefault();
            
            if (confirm('Are you sure you want to submit your quiz? You cannot change your answers after submission.')) {
                this.submit();
            }
        });

        // Initialize
        showQuestion(1);
    </script>
</body>
</html>


