<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $quiz->title }} - Quiz Platform</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .quiz-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 20px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }
        .quiz-header {
            background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
            color: white;
            border-radius: 20px 20px 0 0;
            padding: 2rem;
        }
        .quiz-icon {
            width: 80px;
            height: 80px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 2rem;
            margin: 0 auto 1rem;
        }
        .feature-card {
            background: rgba(255, 255, 255, 0.8);
            border-radius: 15px;
            padding: 1.5rem;
            text-align: center;
            transition: transform 0.3s ease;
        }
        .feature-card:hover {
            transform: translateY(-5px);
        }
        .btn-quiz {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 50px;
            padding: 15px 40px;
            font-weight: 600;
            font-size: 1.1rem;
            color: white;
            transition: all 0.3s ease;
        }
        .btn-quiz:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(102, 126, 234, 0.4);
            color: white;
        }
    </style>
</head>
<body>
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="quiz-card">
                    <!-- Quiz Header -->
                    <div class="quiz-header text-center">
                        <div class="quiz-icon">
                            <i class="fas fa-question-circle"></i>
                        </div>
                        <h1 class="mb-3">{{ $quiz->title }}</h1>
                        <p class="lead mb-0">{{ $quiz->description ?: 'Test your knowledge with this quiz!' }}</p>
                    </div>

                    <!-- Quiz Content -->
                    <div class="p-4">
                        <!-- Quiz Features -->
                        <div class="row g-4 mb-4">
                            <div class="col-md-3">
                                <div class="feature-card">
                                    <i class="fas fa-list-ol fa-2x text-primary mb-3"></i>
                                    <h5>{{ $quiz->total_questions }}</h5>
                                    <small class="text-muted">Questions</small>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="feature-card">
                                    <i class="fas fa-star fa-2x text-warning mb-3"></i>
                                    <h5>{{ $quiz->total_points }}</h5>
                                    <small class="text-muted">Total Points</small>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="feature-card">
                                    <i class="fas fa-clock fa-2x text-info mb-3"></i>
                                    <h5>{{ $quiz->duration_minutes ? $quiz->duration_minutes . ' min' : 'No limit' }}</h5>
                                    <small class="text-muted">Duration</small>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="feature-card">
                                    <i class="fas fa-shield-alt fa-2x text-success mb-3"></i>
                                    <h5>{{ $quiz->require_auth ? 'Secure' : 'Open' }}</h5>
                                    <small class="text-muted">Access</small>
                                </div>
                            </div>
                        </div>

                        <!-- Quiz Instructions -->
                        <div class="alert alert-info">
                            <h6 class="alert-heading">
                                <i class="fas fa-info-circle me-2"></i>Instructions
                            </h6>
                            <ul class="mb-0">
                                <li>You will need to register or login to take this quiz</li>
                                <li>Read each question carefully before answering</li>
                                <li>You can navigate between questions using the navigation buttons</li>
                                @if($quiz->duration_minutes)
                                    <li>You have {{ $quiz->duration_minutes }} minutes to complete the quiz</li>
                                @endif
                                <li>Once you submit, you cannot change your answers</li>
                            </ul>
                        </div>

                        <!-- Action Buttons -->
                        <div class="text-center">
                            @auth
                                <a href="{{ route('quiz.attempt', ['quiz' => $quiz->unique_url, 'token' => request('token')]) }}" 
                                   class="btn btn-quiz btn-lg">
                                    <i class="fas fa-play me-2"></i>Start Quiz
                                </a>
                            @else
                                <a href="{{ route('login') }}?redirect={{ urlencode(route('quiz.attempt', ['quiz' => $quiz->unique_url, 'token' => request('token')])) }}" 
                                   class="btn btn-quiz btn-lg">
                                    <i class="fas fa-sign-in-alt me-2"></i>Login to Start Quiz
                                </a>
                                <div class="mt-3">
                                    <small class="text-muted">
                                        Don't have an account? 
                                        <a href="{{ route('register') }}" class="text-decoration-none">Register here</a>
                                    </small>
                                </div>
                            @endauth
                        </div>
                    </div>
                </div>

                <!-- Footer -->
                <div class="text-center mt-4">
                    <small class="text-white-50">
                        &copy; {{ date('Y') }} Quiz Platform. All rights reserved.
                    </small>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>


