<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $quiz->title }} - Quiz Results</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .result-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 20px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }
        .result-header {
            background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
            color: white;
            border-radius: 20px 20px 0 0;
            padding: 2rem;
            text-align: center;
        }
        .score-circle {
            width: 120px;
            height: 120px;
            border-radius: 50%;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1rem;
            font-size: 2rem;
            font-weight: bold;
            color: white;
        }
        .stat-card {
            background: rgba(255, 255, 255, 0.8);
            border-radius: 15px;
            padding: 1.5rem;
            text-align: center;
            transition: transform 0.3s ease;
        }
        .stat-card:hover {
            transform: translateY(-5px);
        }
        .btn-quiz {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 50px;
            padding: 15px 40px;
            font-weight: 600;
            font-size: 1.1rem;
            color: white;
            transition: all 0.3s ease;
        }
        .btn-quiz:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(102, 126, 234, 0.4);
            color: white;
        }
        .performance-badge {
            font-size: 1.2rem;
            font-weight: bold;
            padding: 0.5rem 1rem;
            border-radius: 25px;
        }
        .excellent { background: linear-gradient(135deg, #4CAF50, #45a049); color: white; }
        .good { background: linear-gradient(135deg, #2196F3, #1976D2); color: white; }
        .average { background: linear-gradient(135deg, #FF9800, #F57C00); color: white; }
        .poor { background: linear-gradient(135deg, #F44336, #D32F2F); color: white; }
    </style>
</head>
<body>
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="result-card">
                    <!-- Result Header -->
                    <div class="result-header">
                        <div class="score-circle">
                            {{ round($result['percentage']) }}%
                        </div>
                        <h1 class="mb-3">Quiz Completed!</h1>
                        <p class="lead mb-0">Congratulations on completing "{{ $quiz->title }}"</p>
                    </div>

                    <!-- Result Content -->
                    <div class="p-4">
                        <!-- Performance Badge -->
                        <div class="text-center mb-4">
                            @php
                                $percentage = $result['percentage'];
                                if ($percentage >= 90) {
                                    $badgeClass = 'excellent';
                                    $badgeText = 'Excellent!';
                                } elseif ($percentage >= 80) {
                                    $badgeClass = 'good';
                                    $badgeText = 'Good Job!';
                                } elseif ($percentage >= 70) {
                                    $badgeClass = 'average';
                                    $badgeText = 'Not Bad!';
                                } else {
                                    $badgeClass = 'poor';
                                    $badgeText = 'Keep Trying!';
                                }
                            @endphp
                            <span class="performance-badge {{ $badgeClass }}">{{ $badgeText }}</span>
                        </div>

                        <!-- Statistics -->
                        <div class="row g-4 mb-4">
                            <div class="col-md-3">
                                <div class="stat-card">
                                    <i class="fas fa-check-circle fa-2x text-success mb-3"></i>
                                    <h4>{{ $result['correct_answers'] }}</h4>
                                    <small class="text-muted">Correct Answers</small>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="stat-card">
                                    <i class="fas fa-times-circle fa-2x text-danger mb-3"></i>
                                    <h4>{{ $result['incorrect_answers'] }}</h4>
                                    <small class="text-muted">Incorrect Answers</small>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="stat-card">
                                    <i class="fas fa-star fa-2x text-warning mb-3"></i>
                                    <h4>{{ $result['score'] }}/{{ $result['total_points'] }}</h4>
                                    <small class="text-muted">Points Earned</small>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="stat-card">
                                    <i class="fas fa-clock fa-2x text-info mb-3"></i>
                                    <h4>{{ $result['time_taken'] ?? 'N/A' }}</h4>
                                    <small class="text-muted">Time Taken</small>
                                </div>
                            </div>
                        </div>

                        <!-- Detailed Results -->
                        <div class="card mb-4">
                            <div class="card-header">
                                <h5 class="mb-0">
                                    <i class="fas fa-list-alt me-2"></i>Detailed Results
                                </h5>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <h6>Quiz Information</h6>
                                        <ul class="list-unstyled">
                                            <li><strong>Quiz:</strong> {{ $quiz->title }}</li>
                                            <li><strong>Total Questions:</strong> {{ $quiz->total_questions }}</li>
                                            <li><strong>Total Points:</strong> {{ $quiz->total_points }}</li>
                                            <li><strong>Completed:</strong> {{ $attempt->completed_at->format('M d, Y H:i') }}</li>
                                        </ul>
                                    </div>
                                    <div class="col-md-6">
                                        <h6>Your Performance</h6>
                                        <ul class="list-unstyled">
                                            <li><strong>Score:</strong> {{ $result['score'] }}/{{ $result['total_points'] }} points</li>
                                            <li><strong>Percentage:</strong> {{ round($result['percentage'], 2) }}%</li>
                                            <li><strong>Correct:</strong> {{ $result['correct_answers'] }}/{{ $quiz->total_questions }}</li>
                                            <li><strong>Status:</strong> 
                                                <span class="badge bg-success">Completed</span>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Action Buttons -->
                        <div class="text-center">
                            <a href="{{ route('quiz.public', $quiz->unique_url) }}" class="btn btn-quiz me-3">
                                <i class="fas fa-redo me-2"></i>Take Quiz Again
                            </a>
                            <a href="{{ route('dashboard') }}" class="btn btn-outline-primary">
                                <i class="fas fa-home me-2"></i>Go to Dashboard
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Footer -->
                <div class="text-center mt-4">
                    <small class="text-white-50">
                        &copy; {{ date('Y') }} Quiz Platform. All rights reserved.
                    </small>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>


