<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $quiz->title }} - Resume Quiz</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .resume-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 20px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }
        .resume-icon {
            width: 100px;
            height: 100px;
            background: linear-gradient(135deg, #4CAF50 0%, #45a049 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 3rem;
            color: white;
            margin: 0 auto 2rem;
        }
        .btn-quiz {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 50px;
            padding: 15px 40px;
            font-weight: 600;
            font-size: 1.1rem;
            color: white;
            transition: all 0.3s ease;
        }
        .btn-quiz:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(102, 126, 234, 0.4);
            color: white;
        }
        .btn-outline-quiz {
            border: 2px solid #667eea;
            color: #667eea;
            border-radius: 50px;
            padding: 15px 40px;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        .btn-outline-quiz:hover {
            background: #667eea;
            color: white;
        }
    </style>
</head>
<body>
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="resume-card text-center p-5">
                    <div class="resume-icon">
                        <i class="fas fa-play-circle"></i>
                    </div>
                    
                    <h1 class="mb-3">Resume Quiz</h1>
                    <p class="lead mb-4">You have an in-progress attempt for "{{ $quiz->title }}"</p>
                    
                    <div class="row g-4 mb-4">
                        <div class="col-md-4">
                            <div class="card h-100">
                                <div class="card-body text-center">
                                    <i class="fas fa-clock fa-2x text-info mb-3"></i>
                                    <h5>Started</h5>
                                    <p class="text-muted mb-0">{{ $existingAttempt->started_at->format('M d, Y H:i') }}</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card h-100">
                                <div class="card-body text-center">
                                    <i class="fas fa-list-ol fa-2x text-primary mb-3"></i>
                                    <h5>Progress</h5>
                                    <p class="text-muted mb-0">{{ $existingAttempt->answers->count() }} / {{ $quiz->total_questions }} questions</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card h-100">
                                <div class="card-body text-center">
                                    <i class="fas fa-hourglass-half fa-2x text-warning mb-3"></i>
                                    <h5>Time Left</h5>
                                    <p class="text-muted mb-0">
                                        @if($existingAttempt->expires_at)
                                            {{ $existingAttempt->expires_at->diffForHumans() }}
                                        @else
                                            No time limit
                                        @endif
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="alert alert-info">
                        <h6 class="alert-heading">
                            <i class="fas fa-info-circle me-2"></i>What would you like to do?
                        </h6>
                        <p class="mb-0">
                            You can continue where you left off, or start a new attempt (this will discard your current progress).
                        </p>
                    </div>
                    
                    <div class="mt-4">
                        <a href="{{ route('quiz.attempt', ['quiz' => $quiz->unique_url, 'token' => request('token')]) }}" 
                           class="btn btn-quiz me-3">
                            <i class="fas fa-play me-2"></i>Continue Quiz
                        </a>
                        <button type="button" class="btn btn-outline-quiz" onclick="startNewAttempt()">
                            <i class="fas fa-redo me-2"></i>Start New Attempt
                        </button>
                    </div>
                </div>
                
                <!-- Footer -->
                <div class="text-center mt-4">
                    <small class="text-white-50">
                        &copy; {{ date('Y') }} Quiz Platform. All rights reserved.
                    </small>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function startNewAttempt() {
            if (confirm('Are you sure you want to start a new attempt? This will discard your current progress.')) {
                // This would need to be implemented to delete the current attempt and start fresh
                window.location.href = "{{ route('quiz.start', ['quiz' => $quiz->unique_url, 'token' => request('token')]) }}";
            }
        }
    </script>
</body>
</html>


