<?php

use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return view('welcome');
});

// Authentication Routes
Route::get('/login', function () {
    return view('Admin.auth.login');
})->name('login');

Route::get('/register', function () {
    return view('Admin.auth.register');
})->name('register');

// Password Reset Routes
Route::get('/forgot-password', function () {
    return view('Admin.auth.forgot-password');
})->name('password.request');

Route::post('/forgot-password', 'App\Http\Controllers\Auth\ForgotPasswordController@sendResetLinkEmail')->name('password.email');

Route::get('/reset-password/{token}', function ($token) {
    return view('Admin.auth.reset-password', ['token' => $token]);
})->name('password.reset');

Route::post('/reset-password', 'App\Http\Controllers\Auth\ResetPasswordController@reset')->name('password.update');

// Public Quiz Routes (for invited users)
Route::get('/quiz/{quiz}', 'App\Http\Controllers\Public\QuizController@show')->name('quiz.public');
Route::get('/quiz/{quiz}/attempt/{token}', 'App\Http\Controllers\Public\QuizController@attempt')->name('quiz.attempt');
Route::post('/quiz/{quiz}/attempt/{token}', 'App\Http\Controllers\Public\QuizController@startAttempt')->name('quiz.start');
Route::post('/quiz/{quiz}/submit/{token}', 'App\Http\Controllers\Public\QuizController@submitAttempt')->name('quiz.submit');

// Test route to debug
Route::get('/test-quiz', function() {
    return 'Quiz routes are working!';
});

Route::get('/quiz-test', 'App\Http\Controllers\Public\QuizController@test');

/* Admin Routes Start */
Route::match(['get','post'],'/admin/login','App\Http\Controllers\Admin\DashboardController@login')->name('admin.login');
Route::match(['get','post'],'/admin/dashboard','App\Http\Controllers\Admin\DashboardController@dashboard');
/* Admin Routes End */


// Authenticated routes
Route::middleware(['auth'])->group(function () {
    Route::get('/dashboard', fn() => view('dashboard'))->name('dashboard');

    // Owner and Administrator routes (full admin access)
    Route::middleware('role:Owner|Administrator')->group(function () {
        Route::get('/admin/dashboard', fn() => view('Admin.dashboard'))->name('admin.dashboard');
        
        // User Management Routes with Permission Checks
        Route::middleware('permission:users.view')->group(function () {
            Route::get('/admin/users', fn() => view('Admin.users'))->name('admin.users');
        });
        
        Route::middleware('permission:users.create')->group(function () {
            Route::get('/admin/users/create', fn() => view('Admin.user-form'))->name('admin.users.create');
        });
        
        Route::middleware('permission:users.edit')->group(function () {
            Route::get('/admin/users/{userId}/edit', fn($userId) => view('Admin.user-form', ['userId' => $userId]))->name('admin.users.edit');
        });
        
        // Role Management Routes
        Route::middleware('permission:roles.view')->group(function () {
            Route::get('/admin/roles', fn() => view('Admin.roles'))->name('admin.roles');
        });
        
        Route::middleware('permission:roles.create')->group(function () {
            Route::get('/admin/roles/create', fn() => view('Admin.role-form'))->name('admin.roles.create');
        });
        
        Route::middleware('permission:roles.edit')->group(function () {
            Route::get('/admin/roles/{roleId}/edit', fn($roleId) => view('Admin.role-form', ['roleId' => $roleId]))->name('admin.roles.edit');
        });
        
        // Quiz Management Routes
        Route::middleware('permission:quizzes.view')->group(function () {
            Route::get('/admin/quizzes', fn() => view('Admin.quizzes'))->name('admin.quizzes');
        });
        
        Route::middleware('permission:quizzes.create')->group(function () {
            Route::get('/admin/quizzes/create', fn() => view('Admin.quiz-form'))->name('admin.quizzes.create');
        });
        
        Route::middleware('permission:quizzes.edit')->group(function () {
            Route::get('/admin/quizzes/{quiz}/edit', fn(\App\Models\Quiz $quiz) => view('Admin.quiz-form', ['quiz' => $quiz]))->name('admin.quizzes.edit');
        });
        
        Route::middleware('permission:quizzes.analytics')->group(function () {
            Route::get('/admin/quizzes/{quiz}/analytics', fn(\App\Models\Quiz $quiz) => view('Admin.quiz-analytics', ['quiz' => $quiz]))->name('admin.quizzes.analytics');
        });
        
        Route::middleware('permission:quizzes.view')->group(function () {
            Route::get('/admin/quizzes/{quiz}', fn(\App\Models\Quiz $quiz) => view('Admin.quiz-show', ['quiz' => $quiz]))->name('admin.quizzes.show');
            Route::get('/admin/quizzes/{quiz}/questions', fn(\App\Models\Quiz $quiz) => view('Admin.quiz-questions', ['quiz' => $quiz]))->name('admin.quizzes.questions');
        });
        
        Route::middleware('permission:quizzes.create')->group(function () {
            Route::get('/admin/quizzes/{quiz}/questions/create', fn(\App\Models\Quiz $quiz) => view('Admin.quiz-question-form', ['quiz' => $quiz]))->name('admin.quizzes.questions.create');
        });
        
        Route::middleware('permission:quizzes.edit')->group(function () {
            Route::get('/admin/quizzes/{quiz}/questions/{question}/edit', fn(\App\Models\Quiz $quiz, \App\Models\QuizQuestion $question) => view('Admin.quiz-question-form', ['quiz' => $quiz, 'question' => $question]))->name('admin.quizzes.questions.edit');
        });

        // Quiz Invitation Routes
        Route::middleware('permission:quizzes.invite')->group(function () {
            Route::get('/admin/quizzes/{quiz}/invitations', fn(\App\Models\Quiz $quiz) => view('Admin.quiz-invitations', ['quiz' => $quiz]))->name('admin.quizzes.invitations');
        });
        

               // Profile and Settings Routes
               Route::get('/admin/profile', fn() => view('Admin.profile'))->name('admin.profile');
               Route::get('/admin/analytics', fn() => view('Admin.analytics'))->name('admin.analytics');
               Route::get('/admin/settings', fn() => view('Admin.settings'))->name('admin.settings')->middleware('permission:settings.view');
               Route::get('/admin/email-settings', fn() => view('Admin.email-settings'))->name('admin.email-settings')->middleware('permission:settings.view');
               Route::get('/admin/help-center', fn() => view('Admin.help-center'))->name('admin.help-center');
               
               // Resources Management Routes
               Route::get('/admin/resources', fn() => view('Admin.resources'))->name('admin.resources')->middleware('permission:resources.view');
               Route::get('/admin/resources/create', fn() => view('Admin.resource-form'))->name('admin.resources.create')->middleware('permission:resources.create');
               Route::get('/admin/resources/{resource}/edit', function($resource) {
                   $resource = \App\Models\Resource::findOrFail($resource);
                   return view('Admin.resource-form', compact('resource'));
               })->name('admin.resources.edit')->middleware('permission:resources.edit');
               
               // Learner Form Management Routes
               Route::get('/admin/learner-forms', fn() => view('Admin.learner-form-management'))->name('admin.learner-forms')->middleware('permission:learners.view');
               Route::get('/admin/learner-forms/create', fn() => view('Admin.learner-form-builder'))->name('admin.learner-forms.create')->middleware('permission:learners.create');
               Route::get('/admin/learner-forms/{form}/edit', function($form) {
                   $form = \App\Models\LearnerForm::findOrFail($form);
                   return view('Admin.learner-form-builder', compact('form'));
               })->name('admin.learner-forms.edit')->middleware('permission:learners.edit');
               Route::get('/admin/learners', fn() => view('Admin.learner-management'))->name('admin.learners')->middleware('permission:learners.view');
               
// Email Templates Management Routes
Route::get('/admin/email-templates', fn() => view('Admin.email-template-management'))->name('admin.email-templates')->middleware('permission:email-templates.view');
Route::get('/admin/email-templates/create', fn() => view('Admin.email-template-form'))->name('admin.email-templates.create')->middleware('permission:email-templates.create');
Route::get('/admin/email-templates/{template}/edit', function($template) {
    $template = \App\Models\EmailTemplate::findOrFail($template);
    return view('Admin.email-template-form', ['template' => $template]);
})->name('admin.email-templates.edit')->middleware('permission:email-templates.edit');

// Email Template Types Management Routes
Route::get('/admin/email-template-types', fn() => view('Admin.email-template-type-management'))->name('admin.email-template-types')->middleware('permission:email-template-types.view');
Route::get('/admin/email-template-types/create', fn() => view('Admin.email-template-type-form'))->name('admin.email-template-types.create')->middleware('permission:email-template-types.create');
Route::get('/admin/email-template-types/{typeId}/edit', function($typeId) {
    return view('Admin.email-template-type-form', ['typeId' => $typeId]);
})->name('admin.email-template-types.edit')->middleware('permission:email-template-types.edit');
    });

    // LLN Specialist routes (specialist access)
    Route::middleware('role:LLN Specialist')->group(function () {
        Route::get('/specialist/dashboard', fn() => view('Specialist.dashboard'))->name('specialist.dashboard');
    });

    // Enrolment Officer routes (enrolment access)
    Route::middleware('role:Enrolment Officer')->group(function () {
        Route::get('/officer/dashboard', fn() => view('Officer.dashboard'))->name('officer.dashboard');
    });

    // Student routes (student access)
    Route::middleware('role:Student')->group(function () {
        Route::get('/student/dashboard', fn() => view('Student.dashboard'))->name('student.dashboard');
    });
});
