<nav id="sidebar" class="sidebar js-sidebar">
    <div class="sidebar-content js-simplebar">
    <a class="sidebar-brand d-flex align-items-center justify-content-center p-3 mb-3 border-bottom sidebar-brand-container" href="<?php echo e(url('/admin/dashboard')); ?>">
        <?php
            $siteLogo = \App\Models\Setting::get('site_logo', '');
            $siteName = \App\Models\Setting::get('site_name', 'LLN Project');
        ?>
        
        <?php if($siteLogo && \Storage::disk('public')->exists($siteLogo)): ?>
            <img src="<?php echo e(asset('storage/' . $siteLogo)); ?>" 
                 alt="<?php echo e($siteName); ?>" 
                 class="img-fluid sidebar-logo">
        <?php else: ?>
            <span class="align-middle fw-semibold text-center text-truncate"><?php echo e($siteName); ?></span>
        <?php endif; ?>
    </a>

        <ul class="sidebar-nav">
            <li class="sidebar-header">
             Pages
            </li>

            <?php if(auth()->guard()->check()): ?>
                <?php if(auth()->user()->hasRole('Owner') || auth()->user()->hasRole('Administrator')): ?>
                    <li class="sidebar-item <?php echo e(request()->is('admin/dashboard') ? 'active' : ''); ?>">
                      <a class="sidebar-link" href="<?php echo e(url('/admin/dashboard')); ?>">
                        <i class="align-middle" data-feather="sliders"></i> <span class="align-middle">Dashboard</span>
                      </a>
                    </li>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users.view')): ?>
                    <li class="sidebar-item <?php echo e(request()->is('admin/users*') ? 'active' : ''); ?>">
                      <a class="sidebar-link" href="<?php echo e(url('/admin/users')); ?>">
                        <i class="align-middle" data-feather="users"></i> <span class="align-middle">Manage Users</span>
                      </a>
                    </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('roles.view')): ?>
                    <li class="sidebar-item <?php echo e(request()->is('admin/roles*') ? 'active' : ''); ?>">
                      <a class="sidebar-link" href="<?php echo e(url('/admin/roles')); ?>">
                        <i class="align-middle" data-feather="user-check"></i> <span class="align-middle">Manage Roles</span>
                      </a>
                    </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('quizzes.view')): ?>
                    <li class="sidebar-item <?php echo e(request()->is('admin/quizzes*') ? 'active' : ''); ?>">
                      <a class="sidebar-link" href="<?php echo e(url('/admin/quizzes')); ?>">
                        <i class="align-middle" data-feather="clipboard"></i> <span class="align-middle">Quiz Management</span>
                      </a>
                    </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('resources.view')): ?>
                    <li class="sidebar-item <?php echo e(request()->is('admin/resources*') ? 'active' : ''); ?>">
                      <a class="sidebar-link" href="<?php echo e(url('/admin/resources')); ?>">
                        <i class="align-middle" data-feather="folder"></i> <span class="align-middle">Resources</span>
                      </a>
                    </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('learners.view')): ?>
                    <li class="sidebar-item <?php echo e(request()->is('admin/learner-forms*') || request()->is('admin/learners*') ? 'active' : ''); ?>">
                      <a class="sidebar-link" href="<?php echo e(url('/admin/learner-forms')); ?>">
                        <i class="align-middle" data-feather="users"></i> <span class="align-middle">Manage Learner Form</span>
                      </a>
                    </li>
                    <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['email-templates.view', 'email-template-types.view'])): ?>
        <li class="sidebar-item <?php echo e(request()->is('admin/email-templates*') || request()->is('admin/email-template-types*') ? 'active' : ''); ?>">
          <a class="sidebar-link" href="#" onclick="toggleEmailMenu(event)">
            <i class="align-middle" data-feather="mail"></i> <span class="align-middle">Email Templates</span>
            <i class="align-middle ms-auto" data-feather="chevron-down" id="emailMenuIcon"></i>
          </a>
          <ul class="sidebar-dropdown list-unstyled <?php echo e(request()->is('admin/email-templates*') || request()->is('admin/email-template-types*') ? 'show' : ''); ?>" id="emailMenu">
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('email-templates.view')): ?>
            <li class="sidebar-item <?php echo e(request()->is('admin/email-templates*') && !request()->is('admin/email-template-types*') ? 'active' : ''); ?>">
              <a class="sidebar-link" href="<?php echo e(url('/admin/email-templates')); ?>">
                <i class="align-middle" data-feather="file-text"></i> <span class="align-middle">Templates</span>
              </a>
            </li>
            <?php endif; ?>
            
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('email-template-types.view')): ?>
            <li class="sidebar-item <?php echo e(request()->is('admin/email-template-types*') ? 'active' : ''); ?>">
              <a class="sidebar-link" href="<?php echo e(url('/admin/email-template-types')); ?>">
                <i class="align-middle" data-feather="tag"></i> <span class="align-middle">Template Types</span>
              </a>
            </li>
            <?php endif; ?>
          </ul>
        </li>
        <?php endif; ?>

                    <?php if(auth()->user()->hasRole('Owner')): ?>
                    <li class="sidebar-header">
                      <span class="align-middle">Owner Settings</span>
                    </li>


               <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('settings.view')): ?>
               <li class="sidebar-item <?php echo e(request()->is('admin/email-settings*') ? 'active' : ''); ?>">
                 <a class="sidebar-link" href="<?php echo e(url('/admin/email-settings')); ?>">
                   <i class="align-middle" data-feather="mail"></i> <span class="align-middle">Email Settings</span>
                 </a>
               </li>
               <?php endif; ?>

               <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('settings.view')): ?>
               <li class="sidebar-item <?php echo e(request()->is('admin/settings*') ? 'active' : ''); ?>">
                 <a class="sidebar-link" href="<?php echo e(url('/admin/settings')); ?>">
                   <i class="align-middle" data-feather="settings"></i> <span class="align-middle">Settings & Privacy</span>
                 </a>
               </li>
               <?php endif; ?>
                    <?php endif; ?>
                <?php elseif(auth()->user()->hasRole('LLN Specialist')): ?>
                    <li class="sidebar-item <?php echo e(request()->is('specialist/dashboard') ? 'active' : ''); ?>">
                      <a class="sidebar-link" href="<?php echo e(url('/specialist/dashboard')); ?>">
                        <i class="align-middle" data-feather="sliders"></i> <span class="align-middle">Specialist Dashboard</span>
                      </a>
                    </li>
                <?php elseif(auth()->user()->hasRole('Enrolment Officer')): ?>
                    <li class="sidebar-item <?php echo e(request()->is('officer/dashboard') ? 'active' : ''); ?>">
                      <a class="sidebar-link" href="<?php echo e(url('/officer/dashboard')); ?>">
                        <i class="align-middle" data-feather="sliders"></i> <span class="align-middle">Officer Dashboard</span>
                      </a>
                    </li>
                <?php elseif(auth()->user()->hasRole('Student')): ?>
                    <li class="sidebar-item <?php echo e(request()->is('student/dashboard') ? 'active' : ''); ?>">
                      <a class="sidebar-link" href="<?php echo e(url('/student/dashboard')); ?>">
                        <i class="align-middle" data-feather="sliders"></i> <span class="align-middle">Student Dashboard</span>
                      </a>
                    </li>
                <?php endif; ?>
            <?php endif; ?>
        </ul>
    </div>
</nav>

<script>
function toggleEmailMenu(event) {
    event.preventDefault();
    const menu = document.getElementById('emailMenu');
    const icon = document.getElementById('emailMenuIcon');
    
    if (menu.classList.contains('show')) {
        menu.classList.remove('show');
        icon.style.transform = 'rotate(0deg)';
    } else {
        menu.classList.add('show');
        icon.style.transform = 'rotate(180deg)';
    }
}
</script>
<!-- Sidebar !--><?php /**PATH D:\xampp\htdocs\LLNProject\resources\views/Admin/layouts/sidebar.blade.php ENDPATH**/ ?>