<div class="container-fluid px-4 py-3">
    <!-- Page Header -->
    <div class="page-header-two-row">
        <div class="page-title-row">
            <h1 class="page-title-two-row">
                <i class="fas fa-<?php echo e($editMode ? 'edit' : 'plus'); ?>"></i>
                <?php echo e($editMode ? 'Edit Resource' : 'Add New Resource'); ?>

            </h1>
        </div>
        <div class="page-actions-row">
            <div class="breadcrumb-section">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="<?php echo e(route('admin.dashboard')); ?>">
                                <i class="fas fa-home me-1"></i>Dashboard
                            </a>
                        </li>
                        <li class="breadcrumb-item">
                            <a href="<?php echo e(route('admin.resources')); ?>">
                                <i class="fas fa-folder me-1"></i>Resources
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            <i class="fas fa-<?php echo e($editMode ? 'edit' : 'plus'); ?> me-1"></i>
                            <?php echo e($editMode ? 'Edit Resource' : 'Add Resource'); ?>

                        </li>
                    </ol>
                </nav>
            </div>
            <div class="action-section">
                <a href="<?php echo e(route('admin.resources')); ?>" class="btn btn-outline-secondary">
                    <i class="fas fa-arrow-left me-2"></i>Back to Resources
                </a>
            </div>
        </div>
    </div>

    <!-- Form Content -->
    <div class="row justify-content-center">
        <div class="col-12 col-xl-10 col-lg-11">
            <!-- Form Card -->
            <div class="card shadow-sm">
                <div class="card-header">
                    <div class="row align-items-center">
                        <div class="col">
                            <h5 class="card-title mb-0">
                                <i class="fas fa-<?php echo e($editMode ? 'edit' : 'plus'); ?> me-2"></i>
                                <?php echo e($editMode ? 'Edit Resource Information' : 'Create New Resource'); ?>

                            </h5>
                            <p class="card-subtitle mb-0 mt-1">
                                <?php echo e($editMode ? 'Update resource details and file' : 'Fill in the information below to create a new resource'); ?>

                            </p>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <form wire:submit.prevent="save" id="resourceForm">
                        <!-- Basic Information -->
                        <div class="row g-3">
                            <div class="col-12">
                                <label for="title" class="form-label">
                                    <i class="fas fa-heading me-1"></i>Title *
                                </label>
                                <input type="text" 
                                       class="form-control <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="title" 
                                       wire:model="title" 
                                       placeholder="Enter resource title"
                                       required>
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> 
                                    <div class="invalid-feedback"><?php echo e($message); ?></div> 
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                            
                            <div class="col-12">
                                <label for="description" class="form-label">
                                    <i class="fas fa-align-left me-1"></i>Description
                                </label>
                                <textarea class="form-control <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> resize-vertical" 
                                          id="description" 
                                          wire:model="description" 
                                          rows="4" 
                                          placeholder="Enter resource description"></textarea>
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> 
                                    <div class="invalid-feedback"><?php echo e($message); ?></div> 
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                <small class="text-muted">Optional description for the resource</small>
                            </div>
                            
                            <div class="col-12">
                                <label for="file" class="form-label">
                                    <i class="fas fa-file me-1"></i>File <?php echo e($editMode ? '' : '*'); ?>

                                </label>
                                
                                <!--[if BLOCK]><![endif]--><?php if($editMode && $existingFileName): ?>
                                    <div class="alert alert-info mb-3">
                                        <div class="d-flex align-items-center">
                                            <i class="fas fa-file-alt me-2"></i>
                                            <div class="flex-grow-1">
                                                <strong>Current File:</strong> <?php echo e($existingFileName); ?>

                                                <br>
                                                <small class="text-muted">
                                                    Type: <?php echo e($existingFileType); ?> | Size: <?php echo e($existingFileSize); ?>

                                                </small>
                                            </div>
                                            <div class="d-flex gap-2">
                                                <!--[if BLOCK]><![endif]--><?php if(strtolower($existingFileType) === 'pdf'): ?>
                                                <a href="<?php echo e($existingFileUrl); ?>" target="_blank" class="btn btn-sm btn-outline-success">
                                                    <i class="fas fa-eye me-1"></i>View
                                                </a>
                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                <a href="<?php echo e($existingFileUrl); ?>" target="_blank" class="btn btn-sm btn-outline-primary">
                                                    <i class="fas fa-download me-1"></i>Download
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                
                                <input type="file" 
                                       class="form-control <?php $__errorArgs = ['file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="file" 
                                       wire:model="file"
                                       accept=".pdf,.doc,.docx">
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> 
                                    <div class="invalid-feedback"><?php echo e($message); ?></div> 
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                <small class="text-muted">
                                    <!--[if BLOCK]><![endif]--><?php if($editMode): ?>
                                        Leave empty to keep current file. Only PDF, DOC, and DOCX files are allowed (Max 10MB).
                                    <?php else: ?>
                                        Only PDF, DOC, and DOCX files are allowed (Max 10MB).
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </small>
                            </div>
                            
                            <div class="col-12">
                                <div class="form-check">
                                    <input class="form-check-input" 
                                           type="checkbox" 
                                           id="is_active" 
                                           wire:model="is_active">
                                    <label class="form-check-label" for="is_active">
                                        <i class="fas fa-toggle-on me-1"></i>Active
                                    </label>
                                </div>
                                <small class="text-muted">Active resources will be visible to users</small>
                            </div>
                        </div>

                        <!-- Form Actions -->
                        <div class="row mt-4">
                            <div class="col-12">
                                <div class="d-flex justify-content-end gap-2">
                                    <button type="button" class="btn btn-outline-secondary" wire:click="cancel">
                                        <i class="fas fa-times me-1"></i>Cancel
                                    </button>
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-<?php echo e($editMode ? 'save' : 'plus'); ?> me-1"></i>
                                        <?php echo e($editMode ? 'Update Resource' : 'Create Resource'); ?>

                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div><?php /**PATH D:\xampp\htdocs\LLNProject\resources\views/livewire/admin/resource-form.blade.php ENDPATH**/ ?>