<div class="container-fluid px-4 py-3">
    <!-- Page Header -->
    <div class="page-header-two-row">
        <div class="page-title-row">
            <h1 class="page-title-two-row">
                <i class="fas fa-users"></i>
                User Management
            </h1>
        </div>
        <div class="page-actions-row">
            <div class="breadcrumb-section">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="<?php echo e(route('admin.dashboard')); ?>">
                                <i class="fas fa-home me-1"></i>Dashboard
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            <i class="fas fa-users me-1"></i>Users
                        </li>
                    </ol>
                </nav>
            </div>
            <div class="action-section">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users.create')): ?>
                <button type="button" class="btn btn-primary" wire:click="openModal()">
                    <i class="fas fa-plus me-2"></i>Add New User
                </button>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">

                <div class="card-body">
                    <!-- Search and Filter -->
                    <div class="row mb-3">
                        <div class="col-md-5">
                            <div class="input-group">
                                <input type="text" class="form-control" placeholder="Search users..." wire:model.live="search">
                                <span class="input-group-text">
                                    <i class="fas fa-search"></i>
                                </span>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <select class="form-select" wire:model.live="statusFilter">
                                <option value="">All Users</option>
                                <option value="1">Active Users</option>
                                <option value="0">Inactive Users</option>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <div class="d-flex gap-2">
                                <!--[if BLOCK]><![endif]--><?php if($search || $statusFilter !== ''): ?>
                                    <button type="button" class="btn btn-outline-secondary btn-sm" wire:click="clearFilters">
                                        <i class="fas fa-times me-1"></i>Clear Filters
                                    </button>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                <div class="text-muted small align-self-center">
                                    <i class="fas fa-info-circle me-1"></i>
                                    <?php echo e($users->total()); ?> user<?php echo e($users->total() !== 1 ? 's' : ''); ?> found
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Inactive Users Notice -->
                    <!--[if BLOCK]><![endif]--><?php if($statusFilter === '0' || ($statusFilter === '' && $users->where('is_active', false)->count() > 0)): ?>
                        <div class="alert alert-warning mb-3" role="alert">
                            <i class="fas fa-exclamation-triangle me-2"></i>
                            <strong>Inactive Users Notice:</strong> Inactive users cannot log in or access any functionality. They will be automatically logged out if they try to access the system.
                        </div>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                    <!-- Users Table -->
                    <div class="table-responsive d-none d-lg-block">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th wire:click="sortBy('name')" class="sortable">
                                        Name 
                                        <!--[if BLOCK]><![endif]--><?php if($sortField === 'name'): ?>
                                            <i class="fas fa-sort-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>"></i>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </th>
                                    <th wire:click="sortBy('email')" class="sortable">
                                        Email 
                                        <!--[if BLOCK]><![endif]--><?php if($sortField === 'email'): ?>
                                            <i class="fas fa-sort-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>"></i>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </th>
                                    <th>Role</th>
                                    <th>Phone</th>
                                    <th wire:click="sortBy('is_active')" class="sortable">
                                        Status 
                                        <!--[if BLOCK]><![endif]--><?php if($sortField === 'is_active'): ?>
                                            <i class="fas fa-sort-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>"></i>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </th>
                                    <th wire:click="sortBy('created_at')" class="sortable">
                                        Created 
                                        <!--[if BLOCK]><![endif]--><?php if($sortField === 'created_at'): ?>
                                            <i class="fas fa-sort-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>"></i>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="avatar-circle bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3 shadow-sm">
                                                    <span class="avatar-text"><?php echo e(strtoupper(substr($user->name, 0, 1))); ?></span>
                                                </div>
                                                <div>
                                                    <div class="fw-bold"><?php echo e($user->name); ?></div>
                                                    <!--[if BLOCK]><![endif]--><?php if($user->date_of_birth): ?>
                                                        <small class="text-muted">Age: <?php echo e(\Carbon\Carbon::parse($user->date_of_birth)->age); ?></small>
                                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>
                                            </div>
                                        </td>
                                        <td><?php echo e($user->email); ?></td>
                                        <td>
                                            <!--[if BLOCK]><![endif]--><?php if($user->roles->count() > 0): ?>
                                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $user->roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <span class="badge bg-info"><?php echo e($role->name); ?></span>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                            <?php else: ?>
                                                <span class="text-muted">No role assigned</span>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        </td>
                                        <td><?php echo e($user->phone ?? 'N/A'); ?></td>
                                        <td>
                                            <!--[if BLOCK]><![endif]--><?php if($user->is_active): ?>
                                                <span class="badge bg-success">Active</span>
                                            <?php else: ?>
                                                <span class="badge bg-danger">Inactive</span>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        </td>
                                        <td><?php echo e($user->created_at->format('M d, Y')); ?></td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users.edit')): ?>
                                                <button type="button" class="btn btn-sm btn-outline-primary" wire:click="openModal(<?php echo e($user->id); ?>)" title="Edit">
                                                    <i class="fas fa-edit"></i>
                                                </button>
                                                <?php endif; ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users.delete')): ?>
                                                <button type="button" class="btn btn-sm btn-outline-danger" 
                                                        wire:click="delete(<?php echo e($user->id); ?>)"
                                                        wire:confirm="<?php echo e($user->id === auth()->id() ? 'You cannot delete your own account!' : 'Are you sure you want to delete this user?'); ?>"
                                                        title="Delete"
                                                        <?php echo e($user->id === auth()->id() ? 'disabled' : ''); ?>>
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="7" class="text-center py-4">
                                            <div class="text-muted">
                                                <i class="fas fa-users fa-2x mb-2"></i>
                                                <p>No users found</p>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <div class="d-flex justify-content-between align-items-center mt-3">
                        <div>
                            Showing <?php echo e($users->firstItem() ?? 0); ?> to <?php echo e($users->lastItem() ?? 0); ?> of <?php echo e($users->total()); ?> results
                        </div>
                        <div>
                            <?php echo e($users->links()); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Mobile Card View -->
    <!--[if BLOCK]><![endif]--><?php if($users->count() > 0): ?>
        <div class="d-lg-none">
            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="card mb-3">
                    <div class="card-body p-3">
                        <div class="row align-items-start mb-3">
                            <div class="col-auto">
                                <div class="avatar-circle bg-primary text-white rounded-circle d-flex align-items-center justify-content-center shadow-sm">
                                    <span class="avatar-text"><?php echo e(strtoupper(substr($user->name, 0, 1))); ?></span>
                                </div>
                            </div>
                            <div class="col">
                                <h6 class="card-title mb-1 fw-semibold"><?php echo e($user->name); ?></h6>
                                <p class="text-muted small mb-1"><?php echo e($user->email); ?></p>
                                <div class="d-flex flex-wrap gap-2 mb-2">
                                    <!--[if BLOCK]><![endif]--><?php if($user->roles->count() > 0): ?>
                                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $user->roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <span class="badge bg-info"><?php echo e($role->name); ?></span>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                    <?php else: ?>
                                        <span class="badge bg-secondary">No role</span>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    <!--[if BLOCK]><![endif]--><?php if($user->is_active): ?>
                                        <span class="badge bg-success">Active</span>
                                    <?php else: ?>
                                        <span class="badge bg-danger">Inactive</span>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <small class="text-muted">
                                    Phone: <?php echo e($user->phone ?? 'N/A'); ?> | Created: <?php echo e($user->created_at->format('M d, Y')); ?>

                                </small>
                            </div>
                        </div>
                        
                        <!-- Action Buttons -->
                        <div class="row g-2">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users.edit')): ?>
                            <div class="col-6">
                                <button type="button" class="btn btn-sm btn-outline-primary w-100" wire:click="openModal(<?php echo e($user->id); ?>)">
                                    <i class="fas fa-edit me-1"></i>Edit
                                </button>
                            </div>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users.delete')): ?>
                            <div class="col-6">
                                <button type="button" class="btn btn-sm btn-outline-danger w-100" 
                                        wire:click="delete(<?php echo e($user->id); ?>)"
                                        wire:confirm="<?php echo e($user->id === auth()->id() ? 'You cannot delete your own account!' : 'Are you sure you want to delete this user?'); ?>"
                                        <?php echo e($user->id === auth()->id() ? 'disabled' : ''); ?>>
                                    <i class="fas fa-trash me-1"></i>Delete
                                </button>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
            
            <!-- Mobile Pagination -->
            <!--[if BLOCK]><![endif]--><?php if($users->hasPages()): ?>
                <div class="d-flex justify-content-center mt-4">
                    <?php echo e($users->links()); ?>

                </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
</div><?php /**PATH D:\xampp\htdocs\LLNProject\resources\views/livewire/admin/user-management.blade.php ENDPATH**/ ?>