<div class="container-fluid px-4 py-3">
    <!-- Page Header -->
    <div class="page-header-two-row">
        <div class="page-title-row">
            <h1 class="page-title-two-row">
                <i class="fas fa-cog"></i>
                Settings & Privacy
            </h1>
        </div>
        <div class="page-actions-row">
            <div class="breadcrumb-section">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="<?php echo e(route('admin.dashboard')); ?>">
                                <i class="fas fa-home me-1"></i>Dashboard
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            <i class="fas fa-cog me-1"></i>Settings
                        </li>
                    </ol>
                </nav>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <form wire:submit.prevent="updateSettings">
                <!-- General Settings -->
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-globe me-2"></i>General Settings
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label for="site_name" class="form-label">Site Name *</label>
                                <input type="text" 
                                       class="form-control <?php $__errorArgs = ['settings.site_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="site_name" 
                                       wire:model="settings.site_name">
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['settings.site_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                            <div class="col-md-6">
                                <label for="site_email" class="form-label">Site Email *</label>
                                <input type="email" 
                                       class="form-control <?php $__errorArgs = ['settings.site_email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="site_email" 
                                       wire:model="settings.site_email">
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['settings.site_email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                            <div class="col-md-6">
                                <label for="site_phone" class="form-label">Site Phone</label>
                                <input type="tel" 
                                       class="form-control <?php $__errorArgs = ['settings.site_phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="site_phone" 
                                       wire:model="settings.site_phone">
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['settings.site_phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                            <div class="col-12">
                                <label for="site_address" class="form-label">Site Address</label>
                                <textarea class="form-control <?php $__errorArgs = ['settings.site_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                          id="site_address" 
                                          wire:model="settings.site_address" 
                                          rows="3"></textarea>
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['settings.site_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                            <div class="col-12">
                                <label for="copyright_text" class="form-label">Copyright Text *</label>
                                <input type="text" 
                                       class="form-control <?php $__errorArgs = ['settings.copyright_text'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="copyright_text" 
                                       wire:model="settings.copyright_text"
                                       placeholder="© 2024 LLN Project. All rights reserved.">
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['settings.copyright_text'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                <small class="text-muted">This text will appear in the footer of your website</small>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Logo Settings -->
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-image me-2"></i>Logo Settings
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-12">
                                <label for="logo" class="form-label">Site Logo</label>
                                <input type="file" 
                                       class="form-control <?php $__errorArgs = ['logo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="logo" 
                                       wire:model="logo"
                                       accept="image/*">
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['logo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                <small class="text-muted">Upload a logo image (PNG, JPG, GIF - Max 2MB)</small>
</div>

                            <!--[if BLOCK]><![endif]--><?php if($logoPreview || $settings['site_logo']): ?>
                            <div class="col-12">
                                <div class="logo-preview-container">
                                    <h6 class="mb-3">Logo Preview:</h6>
                                    <!--[if BLOCK]><![endif]--><?php if($logoPreview): ?>
                                        <img src="<?php echo e($logoPreview); ?>" alt="Logo Preview" class="img-fluid">
                                    <?php elseif($settings['site_logo']): ?>
                                        <img src="<?php echo e(Storage::url($settings['site_logo'])); ?>" alt="Current Logo" class="img-fluid">
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    <div class="mt-3">
                                        <!--[if BLOCK]><![endif]--><?php if($settings['site_logo']): ?>
                                        <button type="button" class="btn btn-danger btn-sm" wire:click="removeLogo">
                                            <i class="fas fa-trash me-1"></i>Remove Logo
                                        </button>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                    </div>
                </div>

                <!-- Organisation Information -->
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-building me-2"></i>Organisation Information
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label for="company_name" class="form-label">Company Name *</label>
                                <input type="text" 
                                       class="form-control <?php $__errorArgs = ['settings.company_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="company_name" 
                                       wire:model="settings.company_name">
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['settings.company_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                            <div class="col-md-6">
                                <label for="learner_correspondence_name" class="form-label">Learner Correspondence Name *</label>
                                <input type="text" 
                                       class="form-control <?php $__errorArgs = ['settings.learner_correspondence_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="learner_correspondence_name" 
                                       wire:model="settings.learner_correspondence_name">
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['settings.learner_correspondence_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                            <div class="col-md-6">
                                <label for="learner_correspondence_phone" class="form-label">Learner Correspondence Phone *</label>
                                <input type="tel" 
                                       class="form-control <?php $__errorArgs = ['settings.learner_correspondence_phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="learner_correspondence_phone" 
                                       wire:model="settings.learner_correspondence_phone">
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['settings.learner_correspondence_phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                            <div class="col-md-6">
                                <label for="learner_correspondence_email" class="form-label">Learner Correspondence Email *</label>
                                <input type="email" 
                                       class="form-control <?php $__errorArgs = ['settings.learner_correspondence_email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="learner_correspondence_email" 
                                       wire:model="settings.learner_correspondence_email">
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['settings.learner_correspondence_email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                            <div class="col-12">
                                <label for="learner_redirection_url" class="form-label">Learner Redirection URL *</label>
                                <input type="url" 
                                       class="form-control <?php $__errorArgs = ['settings.learner_redirection_url'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="learner_redirection_url" 
                                       wire:model="settings.learner_redirection_url">
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['settings.learner_redirection_url'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                            <div class="col-md-6">
                                <label for="admin_correspondence_name" class="form-label">Admin Correspondence Name *</label>
                                <input type="text" 
                                       class="form-control <?php $__errorArgs = ['settings.admin_correspondence_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="admin_correspondence_name" 
                                       wire:model="settings.admin_correspondence_name">
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['settings.admin_correspondence_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                            <div class="col-md-6">
                                <label for="admin_correspondence_email" class="form-label">Admin Correspondence Email *</label>
                                <input type="email" 
                                       class="form-control <?php $__errorArgs = ['settings.admin_correspondence_email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="admin_correspondence_email" 
                                       wire:model="settings.admin_correspondence_email">
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['settings.admin_correspondence_email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>
                    </div>
                </div>

                <!-- System Settings -->
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-server me-2"></i>System Settings
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label for="session_timeout" class="form-label">Session Timeout (minutes) *</label>
                                <input type="number" 
                                       class="form-control <?php $__errorArgs = ['settings.session_timeout'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="session_timeout" 
                                       wire:model="settings.session_timeout" 
                                       min="30" 
                                       max="480">
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['settings.session_timeout'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                            <div class="col-md-6">
                                <label for="max_login_attempts" class="form-label">Max Login Attempts *</label>
                                <input type="number" 
                                       class="form-control <?php $__errorArgs = ['settings.max_login_attempts'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="max_login_attempts" 
                                       wire:model="settings.max_login_attempts" 
                                       min="3" 
                                       max="10">
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['settings.max_login_attempts'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                            <div class="col-md-6">
                                <label for="password_min_length" class="form-label">Password Min Length *</label>
                                <input type="number" 
                                       class="form-control <?php $__errorArgs = ['settings.password_min_length'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="password_min_length" 
                                       wire:model="settings.password_min_length" 
                                       min="6" 
                                       max="20">
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['settings.password_min_length'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Quiz Settings -->
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-question-circle me-2"></i>Quiz Settings
                        </h5>
                    </div>
                    <div class="card-body">
                        <!-- Toggle Switch Settings -->
                        <div class="row g-3 mb-4">
                            <div class="col-md-6">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" 
                                           type="checkbox" 
                                           id="daily_summary_quiz_completion_email" 
                                           wire:model="settings.daily_summary_quiz_completion_email">
                                    <label class="form-check-label" for="daily_summary_quiz_completion_email">
                                        Daily summary quiz completion email
                                    </label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" 
                                           type="checkbox" 
                                           id="immediate_quiz_completion_emails" 
                                           wire:model="settings.immediate_quiz_completion_emails">
                                    <label class="form-check-label" for="immediate_quiz_completion_emails">
                                        Immediate quiz completion emails
                                    </label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" 
                                           type="checkbox" 
                                           id="deleted_learner_notifications" 
                                           wire:model="settings.deleted_learner_notifications">
                                    <label class="form-check-label" for="deleted_learner_notifications">
                                        Deleted learner notifications
                                    </label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" 
                                           type="checkbox" 
                                           id="incomplete_reminders_to_learners" 
                                           wire:model="settings.incomplete_reminders_to_learners">
                                    <label class="form-check-label" for="incomplete_reminders_to_learners">
                                        Incomplete reminders to learners
                                    </label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" 
                                           type="checkbox" 
                                           id="learner_pre_enrolment_report" 
                                           wire:model="settings.learner_pre_enrolment_report">
                                    <label class="form-check-label" for="learner_pre_enrolment_report">
                                        Learner pre-enrolment report
                                    </label>
                                </div>
                            </div>
                        </div>

                        <!-- Horizontal Separator -->
                        <hr class="my-4">

                        <!-- Text and Number Input Settings -->
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label for="daily_summary_email_contact" class="form-label">Daily summary email contact</label>
                                <input type="text" 
                                       class="form-control <?php $__errorArgs = ['settings.daily_summary_email_contact'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="daily_summary_email_contact" 
                                       wire:model="settings.daily_summary_email_contact"
                                       placeholder="- default admin correspondence -">
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['settings.daily_summary_email_contact'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                            <div class="col-md-6">
                                <label for="immediate_completion_email_contact" class="form-label">Immediate completion email contact</label>
                                <input type="text" 
                                       class="form-control <?php $__errorArgs = ['settings.immediate_completion_email_contact'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="immediate_completion_email_contact" 
                                       wire:model="settings.immediate_completion_email_contact"
                                       placeholder="- default admin correspondence -">
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['settings.immediate_completion_email_contact'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                            <div class="col-md-6">
                                <label for="quiz_reminder_days" class="form-label">Quiz reminder days *</label>
                                <input type="number" 
                                       class="form-control <?php $__errorArgs = ['settings.quiz_reminder_days'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="quiz_reminder_days" 
                                       wire:model="settings.quiz_reminder_days" 
                                       min="1" 
                                       max="30"
                                       placeholder="How many days user will get reminder">
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['settings.quiz_reminder_days'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                <small class="text-muted">Number of days to send quiz reminders</small>
                            </div>
                            <div class="col-md-6">
                                <label for="quiz_reminder_gap_days" class="form-label">Quiz reminder gap days *</label>
                                <input type="number" 
                                       class="form-control <?php $__errorArgs = ['settings.quiz_reminder_gap_days'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="quiz_reminder_gap_days" 
                                       wire:model="settings.quiz_reminder_gap_days" 
                                       min="1" 
                                       max="14"
                                       placeholder="Gap between reminders">
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['settings.quiz_reminder_gap_days'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                <small class="text-muted">Days gap between quiz reminders</small>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Feature Settings -->
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-toggle-on me-2"></i>Feature Settings
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" 
                                           type="checkbox" 
                                           id="maintenance_mode" 
                                           wire:model="settings.maintenance_mode">
                                    <label class="form-check-label" for="maintenance_mode">
                                        Maintenance Mode
                                    </label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" 
                                           type="checkbox" 
                                           id="user_registration" 
                                           wire:model="settings.user_registration">
                                    <label class="form-check-label" for="user_registration">
                                        Allow User Registration
                                    </label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" 
                                           type="checkbox" 
                                           id="email_notifications" 
                                           wire:model="settings.email_notifications">
                                    <label class="form-check-label" for="email_notifications">
                                        Email Notifications
                                    </label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" 
                                           type="checkbox" 
                                           id="require_password_confirmation" 
                                           wire:model="settings.require_password_confirmation">
                                    <label class="form-check-label" for="require_password_confirmation">
                                        Require Password Confirmation
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="text-end">
                    <button type="submit" class="btn btn-primary" wire:loading.attr="disabled">
                        <span wire:loading.remove wire:target="updateSettings">
                            <i class="fas fa-save me-2"></i>Save Settings
                        </span>
                        <span wire:loading wire:target="updateSettings">
                            <i class="fas fa-spinner fa-spin me-2"></i>Saving...
                        </span>
                    </button>
                </div>
            </form>
        </div>

        <!-- Privacy Information -->
        <div class="col-lg-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-shield-alt me-2"></i>Privacy Information
                    </h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <h6 class="fw-bold">Data Collection</h6>
                        <p class="text-muted small">We collect only necessary information for user management and system functionality.</p>
                    </div>
                    <div class="mb-3">
                        <h6 class="fw-bold">Data Security</h6>
                        <p class="text-muted small">All user data is encrypted and stored securely following industry best practices.</p>
                    </div>
                    <div class="mb-3">
                        <h6 class="fw-bold">User Rights</h6>
                        <p class="text-muted small">Users have the right to access, modify, or delete their personal information.</p>
                    </div>
                    <div class="mb-3">
                        <h6 class="fw-bold">Cookie Policy</h6>
                        <p class="text-muted small">We use cookies for session management and to improve user experience.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('livewire:init', () => {
    Livewire.on('logo-updated', () => {
        // Refresh the page to update the sidebar logo
        setTimeout(() => {
            window.location.reload();
        }, 1000);
    });
});
</script><?php /**PATH D:\xampp\htdocs\LLNProject\resources\views/livewire/admin/settings.blade.php ENDPATH**/ ?>